/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.policy.filters.strategies.rules;

import ai.philterd.phileas.model.conditions.ParsedCondition;
import ai.philterd.phileas.model.conditions.ParserListener;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataRequest;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataResponse;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataService;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.filters.strategies.AbstractFilterStrategy;
import ai.philterd.phileas.model.services.AnonymizationService;
import ai.philterd.phileas.model.utils.Encryption;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZipCodeFilterStrategy
extends AbstractFilterStrategy {
    private static final Logger LOGGER = LogManager.getLogger(ZipCodeFilterStrategy.class);
    public static final String TRUNCATE = "truncate";
    public static final String POPULATION = "population";
    public static final String ZERO_LEADING = "zero_leading";
    private static final FilterType filterType = FilterType.ZIP_CODE;
    private final transient ZipCodeMetadataService zipCodeMetadataService = new ZipCodeMetadataService();

    @Override
    public FilterType getFilterType() {
        return filterType;
    }

    @Override
    public boolean evaluateCondition(Policy policy, String context, String documentId, String token, String[] window, String condition, double confidence, Map<String, String> attributes) {
        boolean conditionsSatisfied = false;
        List<ParsedCondition> parsedConditions = ParserListener.getTerminals(condition);
        for (ParsedCondition parsedCondition : parsedConditions) {
            if (StringUtils.equalsIgnoreCase((CharSequence)POPULATION, (CharSequence)parsedCondition.getField())) {
                int value = Integer.parseInt(parsedCondition.getValue());
                ZipCodeMetadataResponse response = this.zipCodeMetadataService.getMetadata(new ZipCodeMetadataRequest(token));
                if (response.isExists()) {
                    long populationForZipCode = response.getPopulation();
                    if (StringUtils.equalsIgnoreCase((CharSequence)POPULATION, (CharSequence)parsedCondition.getField())) {
                        conditionsSatisfied = switch (parsedCondition.getOperator()) {
                            case ">" -> {
                                if (populationForZipCode > (long)value) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "<" -> {
                                if (populationForZipCode < (long)value) {
                                    yield true;
                                }
                                yield false;
                            }
                            case ">=" -> {
                                if (populationForZipCode >= (long)value) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "<=" -> {
                                if (populationForZipCode <= (long)value) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "==" -> {
                                if (populationForZipCode == (long)value) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "!=" -> {
                                if (populationForZipCode != (long)value) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> conditionsSatisfied;
                        };
                    }
                } else {
                    conditionsSatisfied = false;
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"token", (CharSequence)parsedCondition.getField())) {
                conditionsSatisfied = this.evaluateTokenCondition(parsedCondition, token, window);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"context", (CharSequence)parsedCondition.getField())) {
                String conditionContext = parsedCondition.getValue();
                conditionsSatisfied = switch (parsedCondition.getOperator()) {
                    case "==" -> StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext);
                    case "!=" -> {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> conditionsSatisfied;
                };
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"confidence", (CharSequence)parsedCondition.getField())) {
                double threshold = Double.parseDouble(parsedCondition.getValue());
                conditionsSatisfied = switch (parsedCondition.getOperator()) {
                    case ">" -> {
                        if (confidence > threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<" -> {
                        if (confidence < threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case ">=" -> {
                        if (confidence >= threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<=" -> {
                        if (confidence <= threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "==" -> {
                        if (confidence == threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "!=" -> {
                        if (confidence != threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> conditionsSatisfied;
                };
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"sentiment", (CharSequence)parsedCondition.getField())) {
                if (attributes.containsKey("sentiment")) {
                    int documentSentiment = Integer.parseInt(attributes.get("sentiment"));
                    int sentimentCondition = Integer.parseInt(parsedCondition.getValue());
                    conditionsSatisfied = switch (parsedCondition.getOperator()) {
                        case ">" -> {
                            if (documentSentiment > sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<" -> {
                            if (documentSentiment < sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case ">=" -> {
                            if (documentSentiment >= sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<=" -> {
                            if (documentSentiment <= sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "==" -> {
                            if (documentSentiment == sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "!=" -> {
                            if (documentSentiment != sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> conditionsSatisfied;
                    };
                } else {
                    conditionsSatisfied = false;
                }
            }
            LOGGER.debug("Condition for [{}] satisfied: {}", (Object)condition, (Object)conditionsSatisfied);
            if (conditionsSatisfied) continue;
            break;
        }
        return conditionsSatisfied;
    }

    @Override
    public Replacement getReplacement(String label, String context, String documentId, String token, String[] window, Crypto crypto, FPE fpe, AnonymizationService anonymizationService, FilterPattern filterPattern) throws Exception {
        Object replacement = null;
        String salt = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"REDACT")) {
            replacement = this.getRedactedToken(token, label, filterType);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"MASK")) {
            int characters = token.length();
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.maskLength, (CharSequence)"SAME")) {
                characters = Integer.parseInt(this.maskLength);
            }
            if (characters < 1) {
                characters = 5;
            }
            replacement = this.maskCharacter.repeat(characters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"RANDOM_REPLACE")) {
            String scope = "DOCUMENT";
            if (StringUtils.equalsIgnoreCase((CharSequence)this.replacementScope, (CharSequence)"CONTEXT")) {
                scope = "CONTEXT";
            }
            replacement = this.getAnonymizedToken(scope, token, anonymizationService);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"STATIC_REPLACE")) {
            replacement = this.staticReplacement;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)TRUNCATE)) {
            int leaveCharacters = ZipCodeFilterStrategy.getValueOrDefault(ZipCodeFilterStrategy.getValueOrDefault(this.truncateDigits, this.truncateLeaveCharacters), 4);
            if (leaveCharacters < 1) {
                leaveCharacters = 1;
            }
            replacement = StringUtils.equalsIgnoreCase((CharSequence)this.truncateDirection, (CharSequence)"LEADING") ? token.substring(0, leaveCharacters) + StringUtils.repeat((String)this.truncateCharacter, (int)Math.min(token.length() - leaveCharacters, 5 - leaveCharacters)) : StringUtils.repeat((String)this.truncateCharacter, (int)Math.min(token.length() - leaveCharacters, 5 - leaveCharacters)) + token.substring(Math.min(token.length() - leaveCharacters, 5 - leaveCharacters), 5);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)ZERO_LEADING)) {
            replacement = "000" + String.valueOf(token.subSequence(3, 5));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"CRYPTO_REPLACE")) {
            replacement = "{{" + Encryption.encrypt(token, crypto) + "}}";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"HASH_SHA256_REPLACE")) {
            if (this.isSalt()) {
                salt = RandomStringUtils.randomAlphanumeric((int)16);
            }
            replacement = DigestUtils.sha256Hex((String)(token + salt));
        } else {
            replacement = this.getRedactedToken(token, label, filterType);
        }
        return new Replacement((String)replacement, salt);
    }

    @Override
    public void setTruncateDigits(Integer truncateDigits) {
        this.setTruncateLeaveCharacters(truncateDigits);
    }

    @Override
    public void setTruncateLeaveCharacters(Integer truncateLeaveCharacters) {
        if (truncateLeaveCharacters < 1 || truncateLeaveCharacters > 4) {
            throw new IllegalArgumentException("Truncate length must be between 1 and 4, inclusive.");
        }
        this.truncateLeaveCharacters = truncateLeaveCharacters;
    }
}

