/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.responses;

import ai.philterd.phileas.model.objects.Explanation;
import ai.philterd.phileas.model.objects.Span;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FilterResponse {
    private final String filteredText;
    private final String context;
    private final String documentId;
    private final int piece;
    private final Explanation explanation;
    private final Map<String, String> attributes;

    public FilterResponse(String filteredText, String context, String documentId, int piece, Explanation explanation, Map<String, String> attributes) {
        this.filteredText = filteredText;
        this.context = context;
        this.documentId = documentId;
        this.piece = piece;
        this.explanation = explanation;
        this.attributes = attributes;
    }

    public static FilterResponse combine(List<FilterResponse> filterResponses, String context, String documentId, String separator) {
        StringBuilder filteredText = new StringBuilder();
        LinkedList<Span> appliedSpans = new LinkedList<Span>();
        LinkedList<Span> identifiedSpans = new LinkedList<Span>();
        List<FilterResponse> sortedFilterResponses = filterResponses.stream().sorted(Comparator.comparing(FilterResponse::getPiece)).toList();
        int documentOffset = 0;
        HashMap<String, String> combinedAttributes = new HashMap<String, String>();
        for (FilterResponse filterResponse : sortedFilterResponses) {
            String pieceFilteredText = filterResponse.getFilteredText() + separator;
            filteredText.append(pieceFilteredText);
            appliedSpans.addAll(Span.shiftSpans(documentOffset, filterResponse.getExplanation().appliedSpans()));
            identifiedSpans.addAll(Span.shiftSpans(documentOffset, filterResponse.getExplanation().identifiedSpans()));
            documentOffset += pieceFilteredText.length();
            combinedAttributes.putAll(filterResponse.getAttributes());
        }
        return new FilterResponse(filteredText.toString().trim(), context, documentId, 0, new Explanation(appliedSpans, identifiedSpans), combinedAttributes);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public final boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String getFilteredText() {
        return this.filteredText;
    }

    public String getContext() {
        return this.context;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public int getPiece() {
        return this.piece;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

