/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderDeserializer
implements JsonDeserializer<String> {
    final Pattern pattern = Pattern.compile("\\$\\{([A-Z0-9_]+)\\}", 2);

    public String deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String deserialized;
        String value = jsonElement.getAsString().trim();
        Matcher matcher = this.pattern.matcher(value);
        boolean matches = matcher.matches();
        if (matches) {
            String placeholder = matcher.group(1);
            deserialized = System.getenv().containsKey(placeholder) ? System.getenv(placeholder) : value;
        } else {
            deserialized = value;
        }
        return deserialized;
    }
}

