/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.codec.digest.MurmurHash3;

public class BloomFilter<T> {
    private final BitSet bitSet;
    private final Function<T, Integer>[] hashFunctions;

    public BloomFilter(int size) {
        this.bitSet = new BitSet(size);
        this.hashFunctions = this.createHashFunctions();
    }

    public BloomFilter(Collection<T> elements) {
        this.bitSet = new BitSet(elements.size());
        this.hashFunctions = this.createHashFunctions();
        this.putAll(elements);
    }

    public void put(T element) {
        for (Function<T, Integer> hashFunction : this.hashFunctions) {
            int hash = hashFunction.apply(element);
            this.bitSet.set(Math.abs(hash) % this.bitSet.size(), true);
        }
    }

    public void putAll(Collection<T> elements) {
        for (T element : elements) {
            for (Function<T, Integer> hashFunction : this.hashFunctions) {
                int hash = hashFunction.apply(element);
                this.bitSet.set(Math.abs(hash) % this.bitSet.size(), true);
            }
        }
    }

    public boolean mightContain(T element) {
        for (Function<T, Integer> hashFunction : this.hashFunctions) {
            int hash = hashFunction.apply(element);
            if (this.bitSet.get(Math.abs(hash) % this.bitSet.size())) continue;
            return false;
        }
        return true;
    }

    private Function<T, Integer>[] createHashFunctions() {
        Function[] functions = new Function[]{element -> {
            byte[] data = element.toString().getBytes(StandardCharsets.UTF_8);
            return MurmurHash3.hash32x86((byte[])data, (int)0, (int)data.length, (int)104729);
        }, element -> {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hash = digest.digest(element.toString().getBytes(StandardCharsets.UTF_8));
                int hashCode = 0;
                for (int i = 0; i < 4; ++i) {
                    hashCode = hashCode << 8 | hash[i] & 0xFF;
                }
                return hashCode;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 algorithm not found", e);
            }
        }};
        return functions;
    }
}

