/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.utils;

import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import com.privacylogistics.FF3Cipher;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Encryption {
    private Encryption() {
    }

    public static String formatPreservingEncrypt(FPE fpe, String token) {
        char[] nonDigits = new char[token.length()];
        StringBuilder tokenBuilder = new StringBuilder();
        for (int i = 0; i < token.length(); ++i) {
            if (!Character.isDigit(token.charAt(i)) && !Character.isAlphabetic(token.charAt(i))) {
                nonDigits[i] = token.charAt(i);
                continue;
            }
            tokenBuilder.append(token.charAt(i));
        }
        String encryptedToken = Encryption.doFormatPreservingEncryption(tokenBuilder.toString(), fpe);
        int encryptedTokenIndex = 0;
        for (int i = 0; i < nonDigits.length; ++i) {
            if (nonDigits[i] != '\u0000') continue;
            nonDigits[i] = encryptedToken.charAt(encryptedTokenIndex++);
        }
        return new String(nonDigits);
    }

    public static String encrypt(String token, Crypto crypto) throws Exception {
        Cipher cipher = Encryption.getCipher(crypto);
        byte[] encrypted = cipher.doFinal(token.getBytes(Charset.defaultCharset()));
        return Base64.encodeBase64String((byte[])encrypted);
    }

    private static Cipher getCipher(Crypto crypto) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, DecoderException {
        byte[] secretKey = Hex.decodeHex((String)crypto.getKey());
        byte[] initVector = Hex.decodeHex((String)crypto.getIv());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)new SecretKeySpec(secretKey, "AES"), new IvParameterSpec(initVector, 0, cipher.getBlockSize()));
        return cipher;
    }

    private static String doFormatPreservingEncryption(String plainText, FPE fpe) {
        if (plainText.length() < 6 || plainText.length() > 56) {
            throw new RuntimeException("Plain text is outside the acceptable length.");
        }
        try {
            FF3Cipher c = new FF3Cipher(fpe.getKey(), fpe.getTweak());
            return c.encrypt(plainText);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException("Unable to encrypt plain text value.", ex);
        }
    }
}

