/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.processors.unstructured;

import ai.philterd.phileas.model.filter.Filter;
import ai.philterd.phileas.model.objects.Explanation;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.responses.FilterResponse;
import ai.philterd.phileas.model.services.DocumentProcessor;
import ai.philterd.phileas.model.services.MetricsService;
import ai.philterd.phileas.model.services.PostFilter;
import ai.philterd.phileas.model.services.SpanDisambiguationService;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class UnstructuredDocumentProcessor
implements DocumentProcessor {
    private final MetricsService metricsService;
    private final SpanDisambiguationService spanDisambiguationService;

    public UnstructuredDocumentProcessor(MetricsService metricsService, SpanDisambiguationService spanDisambiguationService) {
        this.metricsService = metricsService;
        this.spanDisambiguationService = spanDisambiguationService;
    }

    public FilterResponse process(Policy policy, List<Filter> filters, List<PostFilter> postFilters, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List identifiedSpans = new LinkedList();
        for (Filter filter : filters) {
            long startTimeMs = System.currentTimeMillis();
            FilterResult filterResult = filter.filter(policy, context, documentId, piece, input, attributes);
            long elapsedTimeMs = System.currentTimeMillis() - startTimeMs;
            this.metricsService.logFilterTime(filter.getFilterType(), elapsedTimeMs);
            identifiedSpans.addAll(filterResult.getSpans());
        }
        if (this.spanDisambiguationService.isEnabled()) {
            identifiedSpans = this.spanDisambiguationService.disambiguate(context, identifiedSpans);
        }
        identifiedSpans = Span.dropOverlappingSpans(identifiedSpans);
        identifiedSpans.sort(Comparator.comparing(Span::getConfidence));
        for (PostFilter postFilter : postFilters) {
            identifiedSpans = postFilter.filter(input, identifiedSpans);
        }
        List appliedSpans = identifiedSpans.stream().filter(Span::isApplied).filter(Predicate.not(Span::isIgnored)).map(Span::copy).collect(Collectors.toList());
        appliedSpans.forEach(k -> this.metricsService.incrementFilterType(k.getFilterType()));
        Explanation explanation = new Explanation(appliedSpans, identifiedSpans);
        StringBuilder sb = new StringBuilder(input);
        int stringLength = input.length();
        for (int i = 0; i < stringLength; ++i) {
            int replacementLength;
            Span span = Span.doesIndexStartSpan((int)i, appliedSpans);
            if (span == null) continue;
            String replacement = span.getReplacement();
            int spanLength = span.getCharacterEnd() - span.getCharacterStart();
            if (spanLength != (replacementLength = replacement.length())) {
                int shift = (spanLength - replacementLength) * -1;
                appliedSpans = Span.shiftSpans((int)shift, (Span)span, appliedSpans);
                stringLength += shift;
            }
            sb.replace(span.getCharacterStart(), span.getCharacterEnd(), replacement);
            i = span.getCharacterEnd();
        }
        this.metricsService.incrementProcessed();
        return new FilterResponse(sb.toString(), context, documentId, piece, explanation, attributes);
    }
}

