/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.service.ai.sentiment;

import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.services.Classification;
import ai.philterd.phileas.model.services.SentimentDetector;
import ai.philterd.phileas.service.ai.models.ModelCache;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenNLPSentimentDetector
implements SentimentDetector {
    private static final Logger LOGGER = LogManager.getLogger(OpenNLPSentimentDetector.class);

    public Classification classify(Policy policy, String input) throws Exception {
        DocumentCategorizerME documentCategorizerME;
        String modelFileName = policy.getConfig().getAnalysis().getSentiment().getModel();
        if (ModelCache.getInstance().get(modelFileName) != null) {
            LOGGER.debug("Sentiment model retrieved from model cache.");
            documentCategorizerME = ModelCache.getInstance().get(modelFileName);
        } else if (modelFileName.startsWith("classpath:")) {
            String classpathModelFileName = modelFileName.replace("classpath:", "");
            is = this.getClass().getClassLoader().getResourceAsStream(classpathModelFileName);
            DoccatModel model = new DoccatModel(is);
            documentCategorizerME = new DocumentCategorizerME(model);
            ModelCache.getInstance().put(modelFileName, documentCategorizerME);
        } else if (Files.exists(Paths.get(modelFileName, new String[0]), new LinkOption[0])) {
            is = new FileInputStream(modelFileName);
            DoccatModel model = new DoccatModel(is);
            documentCategorizerME = new DocumentCategorizerME(model);
            is.close();
            ModelCache.getInstance().put(modelFileName, documentCategorizerME);
            LOGGER.debug("Sentiment model loaded from disk and cached.");
        } else {
            LOGGER.error("The sentiment model file does not exist: " + modelFileName);
            documentCategorizerME = null;
        }
        if (documentCategorizerME != null) {
            String[] inputSplit = WhitespaceTokenizer.INSTANCE.tokenize(input);
            double[] outcomes = documentCategorizerME.categorize(inputSplit);
            String label = documentCategorizerME.getBestCategory(outcomes);
            double confidence = outcomes[0];
            return new Classification(label, confidence);
        }
        return null;
    }
}

