/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.alerts;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.Alert;
import ai.philterd.phileas.model.services.AlertService;
import ai.philterd.phileas.model.services.CacheService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAlertService
implements AlertService {
    private static final Logger LOGGER = LogManager.getLogger(DefaultAlertService.class);
    private final CacheService cacheService;

    public DefaultAlertService(CacheService cacheService) {
        LOGGER.info("Initializing local alert service.");
        this.cacheService = cacheService;
    }

    public void generateAlert(String policy, String strategyId, String context, String documentId, FilterType filterType) {
        this.cacheService.generateAlert(policy, strategyId, context, documentId, filterType);
    }

    public List<Alert> getAlerts() {
        return this.cacheService.getAlerts();
    }

    public void delete(String alertId) {
        this.cacheService.deleteAlert(alertId);
    }

    public void clear() {
        this.cacheService.clearAlerts();
    }
}

