/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.disambiguation;

import ai.philterd.phileas.model.configuration.PhileasConfiguration;
import ai.philterd.phileas.model.services.CacheService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.digest.MurmurHash3;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSpanDisambiguationService {
    private static final Logger LOGGER = LogManager.getLogger(AbstractSpanDisambiguationService.class);
    private final PhileasConfiguration phileasConfiguration;
    protected boolean enabled;
    protected final int vectorSize;
    protected final boolean ignoreStopWords;
    protected CacheService cacheService;
    protected Set<String> stopwords;

    public AbstractSpanDisambiguationService(PhileasConfiguration phileasConfiguration, CacheService cacheService) throws IOException {
        this.phileasConfiguration = phileasConfiguration;
        this.vectorSize = phileasConfiguration.spanDisambiguationVectorSize();
        this.ignoreStopWords = phileasConfiguration.spanDisambiguationIgnoreStopWords();
        this.stopwords = new HashSet<String>(Arrays.asList(phileasConfiguration.spanDisambiguationStopWords().split("")));
        this.cacheService = cacheService;
        this.enabled = phileasConfiguration.spanDisambiguationEnabled();
    }

    public int hashToken(String token) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.phileasConfiguration.spanDisambiguationHashAlgorithm(), (CharSequence)"murmu3")) {
            return Math.abs(MurmurHash3.hash32x86((byte[])token.getBytes()) % this.vectorSize);
        }
        return Math.abs(token.hashCode() % this.vectorSize);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

