/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.disambiguation;

import ai.philterd.phileas.model.configuration.PhileasConfiguration;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.services.CacheService;
import ai.philterd.phileas.model.services.SpanDisambiguationService;
import ai.philterd.phileas.services.disambiguation.AbstractSpanDisambiguationService;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VectorBasedSpanDisambiguationService
extends AbstractSpanDisambiguationService
implements SpanDisambiguationService {
    private static final Logger LOGGER = LogManager.getLogger(VectorBasedSpanDisambiguationService.class);

    public VectorBasedSpanDisambiguationService(PhileasConfiguration phileasConfiguration, CacheService cacheService) throws IOException {
        super(phileasConfiguration, cacheService);
    }

    public void hashAndInsert(String context, Span span) {
        double[] hashes = this.hash(span);
        this.cacheService.hashAndInsert(context, hashes, span, this.vectorSize);
    }

    public List<Span> disambiguate(String context, List<Span> spans) {
        LinkedHashSet<Span> disambiguatedSpans = new LinkedHashSet<Span>();
        for (Span span : spans) {
            List identicalSpans = Span.getIdenticalSpans((Span)span, spans);
            if (!identicalSpans.isEmpty()) {
                List<FilterType> filterTypes = identicalSpans.stream().map(Span::getFilterType).collect(Collectors.toList());
                FilterType disambiguatedFilterType = this.disambiguate(context, filterTypes, span);
                span.setFilterType(disambiguatedFilterType);
                disambiguatedSpans.add(span);
                continue;
            }
            disambiguatedSpans.add(span);
        }
        return new LinkedList<Span>(disambiguatedSpans);
    }

    public FilterType disambiguate(String context, List<FilterType> filterTypes, Span ambiguousSpan) {
        HashMap<FilterType, double[]> spanVectors = new HashMap<FilterType, double[]>();
        for (FilterType filterType : filterTypes) {
            LOGGER.debug("Getting vector representation for filter type {}", (Object)filterType.name());
            Map vectorRepresentation = this.cacheService.getVectorRepresentation(context, filterType);
            double[] spanVector = new double[this.vectorSize];
            Iterator iterator = vectorRepresentation.keySet().iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                spanVector[(int)d] = (Double)vectorRepresentation.get(d);
            }
            spanVectors.put(filterType, spanVector);
        }
        double[] ambiguousSpanVector = this.hash(ambiguousSpan);
        LOGGER.debug("Ambiguous: {}", (Object)StringUtils.leftPad((String)Arrays.toString(ambiguousSpanVector), (int)20));
        HashMap<FilterType, Double> distances = new HashMap<FilterType, Double>();
        for (FilterType filterType : spanVectors.keySet()) {
            double[] spanVector = (double[])spanVectors.get(filterType);
            LOGGER.debug("Vector {}: {}", (Object)StringUtils.rightPad((String)filterType.name(), (int)20), (Object)Arrays.toString(spanVector));
            double[] normalized = this.normalize(spanVector, ambiguousSpanVector);
            LOGGER.debug("Normalized {}: {}", (Object)StringUtils.rightPad((String)filterType.name(), (int)20), (Object)Arrays.toString(normalized));
            double distance = VectorBasedSpanDisambiguationService.cosineSimilarity(spanVector, normalized);
            distances.put(filterType, distance);
        }
        DecimalFormat df = new DecimalFormat("0.000000000000000");
        for (FilterType filterType : distances.keySet()) {
            LOGGER.debug("Filter Type {}: {}", (Object)filterType.name(), (Object)df.format(distances.get(filterType)));
        }
        return (FilterType)Collections.max(distances.entrySet(), Map.Entry.comparingByValue()).getKey();
    }

    private double[] hash(Span span) {
        String[] window;
        double[] vector = new double[this.vectorSize];
        for (String token : window = span.getWindow()) {
            String lowerCasedToken = token.toLowerCase().trim();
            if (this.ignoreStopWords && this.stopwords.contains(lowerCasedToken)) continue;
            int hash = this.hashToken(token);
            vector[hash] = 1.0;
        }
        return vector;
    }

    private double[] normalize(double[] vector, double[] ambiguousVector) {
        double[] normalized = new double[this.vectorSize];
        for (int x = 0; x < vector.length; ++x) {
            normalized[x] = vector[x] != 0.0 && ambiguousVector[x] != 0.0 ? vector[x] : ambiguousVector[x];
        }
        return normalized;
    }

    public static double cosineSimilarity(double[] vectorA, double[] vectorB) {
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            dotProduct += vectorA[i] * vectorB[i];
            normA += Math.pow(vectorA[i], 2.0);
            normB += Math.pow(vectorB[i], 2.0);
        }
        return dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
    }
}

