/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.services.pdf;

import ai.philterd.phileas.model.enums.MimeType;
import ai.philterd.phileas.model.objects.PdfRedactionOptions;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.graphical.BoundingBox;
import ai.philterd.phileas.model.services.Redacter;
import ai.philterd.services.pdf.model.RedactedRectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PdfRedacter
extends PDFTextStripper
implements Redacter {
    private static final Logger LOGGER = LogManager.getLogger(PdfRedacter.class);
    private Map<Integer, List<RedactedRectangle>> rectangles = new HashMap<Integer, List<RedactedRectangle>>();
    private Policy policy;
    private final Set<Span> spans;
    private final PdfRedactionOptions pdfRedactionOptions;
    private final List<BoundingBox> boundingBoxes;
    private static final Map<String, PDColor> COLORS = new LinkedHashMap<String, PDColor>();
    private static final Map<String, PDFont> FONTS = new LinkedHashMap<String, PDFont>();
    private final boolean showReplacement;
    private final float replacementFontSize;
    private final PDFont replacementFont;
    private final PDColor replacementFontColor;

    public PdfRedacter(Policy policy, Set<Span> spans, PdfRedactionOptions pdfRedactionOptions, List<BoundingBox> boundingBoxes) throws IOException {
        this.policy = policy;
        this.spans = spans;
        this.pdfRedactionOptions = pdfRedactionOptions;
        this.boundingBoxes = boundingBoxes;
        this.showReplacement = policy.getConfig().getPdf().getShowReplacement();
        this.replacementFont = FONTS.getOrDefault(policy.getConfig().getPdf().getReplacementFont(), FONTS.get("helvetica"));
        this.replacementFontSize = policy.getConfig().getPdf().getReplacementMaxFontSize();
        this.replacementFontColor = COLORS.getOrDefault(policy.getConfig().getPdf().getReplacementFontColor(), COLORS.get("white"));
    }

    public byte[] process(byte[] document, MimeType outputMimeType) throws IOException {
        PDDocument pdDocument = Loader.loadPDF((byte[])document);
        this.setSortByPosition(true);
        this.setStartPage(0);
        this.setEndPage(pdDocument.getNumberOfPages());
        OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
        this.writeText(pdDocument, dummy);
        ((Writer)dummy).close();
        for (BoundingBox boundingBox : this.boundingBoxes) {
            PDPage page = pdDocument.getPage(boundingBox.getPage() - 1);
            PDPageContentStream contentStream = new PDPageContentStream(pdDocument, page, PDPageContentStream.AppendMode.APPEND, true);
            contentStream.setNonStrokingColor(COLORS.getOrDefault(boundingBox.getColor(), COLORS.get("black")));
            contentStream.addRect(boundingBox.getX(), boundingBox.getY(), boundingBox.getW(), boundingBox.getH());
            contentStream.fill();
            contentStream.close();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.setUseCache(false);
        PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
        if (outputMimeType == MimeType.IMAGE_JPEG) {
            ZipOutputStream zipOut = new ZipOutputStream(outputStream);
            for (int x = 0; x < pdDocument.getNumberOfPages(); ++x) {
                LOGGER.debug("Creating image from PDF page " + x);
                BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(x, (float)this.pdfRedactionOptions.getDpi());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
                ImageWriteParam imageWriteParam = writer.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(this.pdfRedactionOptions.getCompressionQuality());
                writer.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
                writer.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                ZipEntry zipEntry = new ZipEntry("page-" + x + ".png");
                zipEntry.setSize(byteArrayOutputStream.size());
                zipOut.putNextEntry(zipEntry);
                zipOut.write(byteArrayOutputStream.toByteArray());
                zipOut.closeEntry();
            }
            zipOut.close();
            pdDocument.close();
        } else if (outputMimeType == MimeType.APPLICATION_PDF) {
            pdfRenderer.setSubsamplingAllowed(true);
            PDDocument outputPdfDocument = new PDDocument();
            boolean preserveUnredactedPages = this.pdfRedactionOptions.getPreserveUnredactedPages();
            for (int x = 0; x < pdDocument.getNumberOfPages(); ++x) {
                if (preserveUnredactedPages && !this.rectangles.containsKey(x)) {
                    LOGGER.debug("Copying page " + x + " from input to output document as no redaction needed on page");
                    PDPage inputPage = pdDocument.getPage(x);
                    outputPdfDocument.importPage(inputPage);
                    continue;
                }
                LOGGER.debug("Creating image from redacted PDF page " + x);
                BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(x, (float)this.pdfRedactionOptions.getDpi(), ImageType.RGB);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageWriter writer = ImageIO.getImageWritersByFormatName("JPEG").next();
                ImageWriteParam imageWriteParam = writer.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(this.pdfRedactionOptions.getCompressionQuality());
                writer.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
                writer.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                writer.dispose();
                byte[] bytes = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                BufferedImage newBi = ImageIO.read(is);
                ((InputStream)is).close();
                PDImageXObject pdImage = JPEGFactory.createFromImage((PDDocument)outputPdfDocument, (BufferedImage)newBi);
                int outputWidthPixels = Math.round(pdDocument.getPage(x).getMediaBox().getWidth());
                int outputHeightPixels = Math.round(pdDocument.getPage(x).getMediaBox().getHeight());
                float scale = this.pdfRedactionOptions.getScale();
                PDRectangle pdRectangle = new PDRectangle((float)outputWidthPixels * scale, (float)outputHeightPixels * scale);
                PDPage page = new PDPage(pdRectangle);
                outputPdfDocument.addPage(page);
                try (PDPageContentStream contentStream = new PDPageContentStream(outputPdfDocument, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                    contentStream.drawImage(pdImage, 0.0f, 0.0f, (float)outputWidthPixels * scale, (float)outputHeightPixels * scale);
                    continue;
                }
            }
            outputPdfDocument.save((OutputStream)outputStream);
            outputPdfDocument.close();
            pdDocument.close();
        } else {
            throw new IllegalArgumentException("Invalid output mime type.");
        }
        return outputStream.toByteArray();
    }

    protected void endDocument(PDDocument doc) throws IOException {
        int buffer = 10;
        for (int pageNumber : this.rectangles.keySet()) {
            PDPage page = this.document.getPage(pageNumber);
            PDPageContentStream rectContentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
            PDPageContentStream textContentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
            for (RedactedRectangle rectangle : this.rectangles.get(pageNumber)) {
                rectContentStream.addRect(rectangle.getPdRectangle().getLowerLeftX(), rectangle.getPdRectangle().getLowerLeftY() - 3.0f, rectangle.getPdRectangle().getWidth(), rectangle.getPdRectangle().getHeight() + 10.0f);
                if (!this.showReplacement) continue;
                this.addReplacementTextToRect(rectangle, textContentStream);
            }
            PDColor pdColor = COLORS.getOrDefault(this.policy.getConfig().getPdf().getRedactionColor(), COLORS.get("black"));
            rectContentStream.setNonStrokingColor(pdColor);
            rectContentStream.setRenderingMode(RenderingMode.FILL);
            rectContentStream.fill();
            rectContentStream.close();
            textContentStream.close();
        }
    }

    public void addReplacementTextToRect(RedactedRectangle rectangle, PDPageContentStream textContentStream) throws IOException {
        String replacementText = rectangle.getSpan().getReplacement();
        float rectangleWidth = rectangle.getPdRectangle().getWidth();
        float rectangleHeight = rectangle.getPdRectangle().getHeight();
        float boxFontSize = this.replacementFontSize;
        float textWidth = this.replacementFont.getStringWidth(replacementText) / 1000.0f * boxFontSize;
        while (textWidth > rectangleWidth) {
            textWidth = this.replacementFont.getStringWidth(replacementText) / 1000.0f * (boxFontSize -= 1.0f);
        }
        float textDescent = this.replacementFont.getFontDescriptor().getDescent() / 1000.0f * boxFontSize;
        float textXLocation = rectangle.getPdRectangle().getLowerLeftX() + (rectangleWidth / 2.0f - textWidth / 2.0f);
        float textYLocation = rectangle.getPdRectangle().getLowerLeftY() + (rectangleHeight / 2.0f + textDescent / 2.0f);
        textContentStream.beginText();
        textContentStream.setNonStrokingColor(this.replacementFontColor);
        textContentStream.setFont(this.replacementFont, boxFontSize);
        textContentStream.newLineAtOffset(textXLocation, textYLocation);
        textContentStream.showText(replacementText);
        textContentStream.endText();
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        float posXInit = 0.0f;
        float posXEnd = 0.0f;
        float posYInit = 0.0f;
        float posYEnd = 0.0f;
        float width = 0.0f;
        float height = 0.0f;
        float fontHeight = 0.0f;
        for (Span span : this.spans) {
            if (!text.contains(span.getText())) continue;
            String term = span.getText();
            List<Integer> indexes = this.findIndexes(text, span);
            for (int index : indexes) {
                if (index + term.length() >= textPositions.size()) {
                    posXEnd = textPositions.get(textPositions.size() - 1).getXDirAdj() + textPositions.get(textPositions.size() - 1).getWidth();
                    posYEnd = textPositions.get(index).getPageHeight() - textPositions.get(textPositions.size() - 1).getYDirAdj();
                } else {
                    posXEnd = textPositions.get(index + term.length()).getXDirAdj() + textPositions.get(index + term.length()).getWidth();
                    posYEnd = textPositions.get(index).getPageHeight() - textPositions.get(index + term.length()).getYDirAdj();
                }
                posXInit = textPositions.get(index).getXDirAdj();
                height = textPositions.get(index).getHeightDir();
                PDRectangle position = new PDRectangle();
                position.setLowerLeftX(posXInit);
                position.setLowerLeftY(posYEnd);
                position.setUpperRightX(posXEnd);
                position.setUpperRightY(posYEnd + height);
                this.rectangles.putIfAbsent(this.getCurrentPageNo() - 1, new LinkedList());
                RedactedRectangle redactedRectangle = new RedactedRectangle(position, span);
                this.rectangles.get(this.getCurrentPageNo() - 1).add(redactedRectangle);
            }
        }
    }

    private List<Integer> findIndexes(String text, Span span) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int index = 0;
        while (index != -1) {
            index = text.indexOf(span.getText(), index);
            if (index == -1) continue;
            indexes.add(index);
            ++index;
        }
        return indexes;
    }

    static {
        COLORS.put("white", new PDColor(new float[]{255.0f, 255.0f, 255.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        COLORS.put("black", new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        COLORS.put("red", new PDColor(new float[]{255.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        COLORS.put("yellow", new PDColor(new float[]{1.0f, 1.0f, 0.39215687f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        FONTS.put("helvetica", (PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA));
        FONTS.put("times", (PDFont)new PDType1Font(Standard14Fonts.FontName.TIMES_ROMAN));
        FONTS.put("courier", (PDFont)new PDType1Font(Standard14Fonts.FontName.COURIER));
    }
}

