/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.services.pdf;

import ai.philterd.phileas.model.services.TextExtractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PdfTextExtractor
extends PDFTextStripper
implements TextExtractor {
    private static final Logger LOGGER = LogManager.getLogger(PdfTextExtractor.class);
    private List<String> lines = new LinkedList<String>();

    public List<String> getLines(byte[] document) throws IOException {
        PDDocument pdDocument = Loader.loadPDF((byte[])document);
        this.setSortByPosition(true);
        this.setStartPage(0);
        this.setEndPage(pdDocument.getNumberOfPages());
        OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
        this.writeText(pdDocument, dummy);
        pdDocument.close();
        LOGGER.debug("Read {} lines from the PDF.", (Object)this.lines.size());
        return this.lines;
    }

    public void writeString(String str, List<TextPosition> textPositions) {
        this.lines.add(str);
    }
}

