/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.policies;

import ai.philterd.phileas.model.exceptions.api.BadRequestException;
import ai.philterd.phileas.model.services.AbstractPolicyService;
import ai.philterd.phileas.model.services.PolicyService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class InMemoryPolicyService
extends AbstractPolicyService
implements PolicyService {
    private static final Logger LOGGER = LogManager.getLogger(InMemoryPolicyService.class);
    private final Map<String, String> policies = new HashMap<String, String>();

    public List<String> get() throws IOException {
        return this.policies.keySet().stream().toList();
    }

    public String get(String policyName) throws IOException {
        return this.policies.get(policyName);
    }

    public Map<String, String> getAll() throws IOException {
        return this.policies;
    }

    public void save(String policyJson) {
        try {
            JSONObject object = new JSONObject(policyJson);
            String policyName = object.getString("name");
            this.policies.put(policyName, policyJson);
        }
        catch (JSONException ex) {
            LOGGER.error("The provided policy is not valid.", (Throwable)ex);
            throw new BadRequestException("The provided policy is not valid.");
        }
    }

    public void delete(String policyName) {
        this.policies.remove(policyName);
    }
}

