/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.policies;

import ai.philterd.phileas.model.configuration.PhileasConfiguration;
import ai.philterd.phileas.model.exceptions.api.BadRequestException;
import ai.philterd.phileas.model.services.AbstractPolicyService;
import ai.philterd.phileas.model.services.CacheService;
import ai.philterd.phileas.model.services.PolicyService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalPolicyService
extends AbstractPolicyService
implements PolicyService {
    private static final Logger LOGGER = LogManager.getLogger(LocalPolicyService.class);
    private static final String JSON_EXTENSION = ".json";
    private final String policiesDirectory;
    private final CacheService cacheService;

    public LocalPolicyService(PhileasConfiguration phileasConfiguration, CacheService cacheService) {
        this.policiesDirectory = phileasConfiguration.policiesDirectory();
        LOGGER.info("Looking for policies in {}", (Object)this.policiesDirectory);
        this.cacheService = cacheService;
    }

    public List<String> get() throws IOException {
        LinkedList<String> names = new LinkedList<String>();
        Collection files = FileUtils.listFiles((File)new File(this.policiesDirectory), (String[])new String[]{"json"}, (boolean)false);
        for (File file : files) {
            String json = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            JSONObject object = new JSONObject(json);
            String name = object.getString("name");
            names.add(name);
        }
        return names;
    }

    public String get(String policyName) throws IOException {
        String policyJson = this.cacheService.getPolicy(policyName);
        if (policyJson == null) {
            File file = new File(this.policiesDirectory, policyName + JSON_EXTENSION);
            if (file.exists()) {
                policyJson = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
                this.cacheService.insertPolicy(policyName, policyJson);
            } else {
                throw new FileNotFoundException("Policy [" + policyName + "] does not exist.");
            }
        }
        return policyJson;
    }

    public Map<String, String> getAll() throws IOException {
        HashMap<String, String> policies = new HashMap<String, String>();
        Collection files = FileUtils.listFiles((File)new File(this.policiesDirectory), (String[])new String[]{"json"}, (boolean)false);
        LOGGER.info("Found {} policies", (Object)files.size());
        for (File file : files) {
            LOGGER.info("Loading policy {}", (Object)file.getAbsolutePath());
            String json = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            JSONObject object = new JSONObject(json);
            String name = object.getString("name");
            policies.put(name, json);
            LOGGER.info("Added policy named [{}]", (Object)name);
        }
        return policies;
    }

    public void save(String policyJson) throws IOException {
        try {
            JSONObject object = new JSONObject(policyJson);
            String policyName = object.getString("name");
            File file = new File(this.policiesDirectory, policyName + JSON_EXTENSION);
            FileUtils.writeStringToFile((File)file, (String)policyJson, (Charset)Charset.defaultCharset());
            this.cacheService.insertPolicy(policyName, policyJson);
        }
        catch (JSONException ex) {
            LOGGER.error("The provided policy is not valid.", (Throwable)ex);
            throw new BadRequestException("The provided policy is not valid.");
        }
    }

    public void delete(String policyName) throws IOException {
        File file = new File(this.policiesDirectory, policyName + JSON_EXTENSION);
        LOGGER.info("Deleting policy at: {}", (Object)file.getAbsolutePath());
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("Unable to delete policy " + policyName + JSON_EXTENSION);
            }
        } else {
            throw new FileNotFoundException("Policy with name " + policyName + " does not exist.");
        }
        this.cacheService.removePolicy(policyName);
    }
}

