/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.policies.utils;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.services.PolicyService;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolicyUtils {
    private static final Logger LOGGER = LogManager.getLogger(PolicyUtils.class);
    private PolicyService policyService;
    private Gson gson;

    public PolicyUtils(PolicyService policyService, Gson gson) {
        this.policyService = policyService;
        this.gson = gson;
    }

    public Policy getCombinedPolicies(List<String> policyNames) throws IOException, IllegalStateException {
        Policy combinedPolicy = this.getPolicy(policyNames.get(0));
        if (policyNames.size() > 1) {
            combinedPolicy.setName("combined");
            for (String policyName : policyNames.subList(1, policyNames.size())) {
                Policy policy = this.getPolicy(policyName);
                for (FilterType filterType : FilterType.values()) {
                    if (!policy.getIdentifiers().hasFilter(filterType)) continue;
                    if (!combinedPolicy.getIdentifiers().hasFilter(filterType)) {
                        combinedPolicy.getIdentifiers().setFilter(filterType, policy.getIdentifiers().getFilter(filterType));
                        continue;
                    }
                    throw new IllegalStateException("Policy has duplicate filter: " + filterType.toString());
                }
                combinedPolicy.getIgnored().addAll(policy.getIgnored());
                combinedPolicy.getIgnoredPatterns().addAll(policy.getIgnoredPatterns());
            }
        }
        return combinedPolicy;
    }

    private Policy getPolicy(String policyName) throws IOException {
        String policyJson = this.policyService.get(policyName);
        LOGGER.debug("Deserializing policy [{}]", (Object)policyName);
        return (Policy)this.gson.fromJson(policyJson, Policy.class);
    }
}

