/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.split;

import ai.philterd.phileas.model.services.SplitService;
import ai.philterd.phileas.services.split.LineWidthSplitService;
import ai.philterd.phileas.services.split.NewLineSplitService;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SplitFactory {
    private static final Logger LOGGER = LogManager.getLogger(SplitFactory.class);

    public static SplitService getSplitService(String method) throws IOException {
        if (StringUtils.equalsIgnoreCase((CharSequence)"newline", (CharSequence)method)) {
            LOGGER.debug("Instantiating a newline split service.");
            return new NewLineSplitService();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"width", (CharSequence)method)) {
            LOGGER.debug("Instantiating a line width split service.");
            return new LineWidthSplitService(500);
        }
        LOGGER.warn("No matching split service found for {}. Defaulting to newline split service.", (Object)method);
        return new NewLineSplitService();
    }
}

