/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.cheetah;

import ai.picovoice.cheetah.CheetahException;
import ai.picovoice.cheetah.CheetahIOException;
import ai.picovoice.cheetah.CheetahInvalidArgumentException;
import ai.picovoice.cheetah.CheetahInvalidStateException;
import ai.picovoice.cheetah.CheetahNative;
import ai.picovoice.cheetah.CheetahRuntimeException;
import ai.picovoice.cheetah.CheetahTranscript;
import ai.picovoice.cheetah.Utils;
import java.io.File;

public class Cheetah {
    private static String sdk = "java";
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();
    private long handle;

    public static void setSdk(String sdk) {
        Cheetah.sdk = sdk;
    }

    private Cheetah(String accessKey, String modelPath, String libraryPath, float endpointDurationSec, boolean enableAutomaticPunctuation) throws CheetahException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new CheetahException(exception);
        }
        CheetahNative.setSdk(sdk);
        this.handle = CheetahNative.init(accessKey, modelPath, endpointDurationSec, enableAutomaticPunctuation);
    }

    public void delete() {
        if (this.handle != 0L) {
            CheetahNative.delete(this.handle);
            this.handle = 0L;
        }
    }

    public CheetahTranscript process(short[] pcm) throws CheetahException {
        if (this.handle == 0L) {
            throw new CheetahInvalidStateException("Attempted to call Cheetah process after delete.");
        }
        if (pcm == null) {
            throw new CheetahInvalidArgumentException("Passed null frame to Cheetah process.");
        }
        if (pcm.length != this.getFrameLength()) {
            throw new CheetahInvalidArgumentException(String.format("Cheetah process requires frames of length %d. Received frame of size %d.", this.getFrameLength(), pcm.length));
        }
        return CheetahNative.process(this.handle, pcm);
    }

    public CheetahTranscript flush() throws CheetahException {
        if (this.handle == 0L) {
            throw new CheetahInvalidStateException("Attempted to call Cheetah flush after delete.");
        }
        return CheetahNative.flush(this.handle);
    }

    public int getFrameLength() {
        return CheetahNative.getFrameLength();
    }

    public int getSampleRate() {
        return CheetahNative.getSampleRate();
    }

    public String getVersion() {
        return CheetahNative.getVersion();
    }

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private float endpointDuration = 1.0f;
        private boolean enableAutomaticPunctuation = false;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setEndpointDuration(float endpointDuration) {
            this.endpointDuration = endpointDuration;
            return this;
        }

        public Builder setEnableAutomaticPunctuation(boolean enableAutomaticPunctuation) {
            this.enableAutomaticPunctuation = enableAutomaticPunctuation;
            return this;
        }

        public Cheetah build() throws CheetahException {
            if (!Utils.isEnvironmentSupported()) {
                throw new CheetahRuntimeException("Could not initialize Cheetah. Execution environment not currently supported by Cheetah Java.");
            }
            if (this.accessKey == null) {
                throw new CheetahInvalidArgumentException("AccessKey must not be null");
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new CheetahInvalidArgumentException("Default library unavailable. Please provide a native Cheetah library path (-l <library_path>).");
                }
                this.libraryPath = LIBRARY_PATH;
                if (!new File(this.libraryPath).exists()) {
                    throw new CheetahIOException(String.format("Couldn't find library file at '%s'", this.libraryPath));
                }
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new CheetahInvalidArgumentException("Default model unavailable. Please provide a valid Cheetah model path (-m <model_path>).");
                }
                this.modelPath = MODEL_PATH;
                if (!new File(this.modelPath).exists()) {
                    throw new CheetahIOException(String.format("Couldn't find model file at '%s'", this.modelPath));
                }
            }
            if (this.endpointDuration < 0.0f) {
                throw new CheetahInvalidArgumentException("endpointDuration must be greater than or equal to 0.0");
            }
            return new Cheetah(this.accessKey, this.modelPath, this.libraryPath, this.endpointDuration, this.enableAutomaticPunctuation);
        }
    }
}

