/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.cheetah;

public class CheetahException
extends Exception {
    private final String message;
    private final String[] messageStack;

    public CheetahException(Throwable cause) {
        super(cause);
        this.message = cause.getMessage();
        this.messageStack = null;
    }

    public CheetahException(String message) {
        super(message);
        this.message = message;
        this.messageStack = null;
    }

    public CheetahException(String message, String[] messageStack) {
        super(message);
        this.message = message;
        this.messageStack = messageStack;
    }

    public String[] getMessageStack() {
        return this.messageStack;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(this.message);
        if (this.messageStack != null && this.messageStack.length > 0) {
            sb.append(":");
            for (int i = 0; i < this.messageStack.length; ++i) {
                sb.append(String.format("\n  [%d] %s", i, this.messageStack[i]));
            }
        }
        return sb.toString();
    }
}

