/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.leopard;

import ai.picovoice.leopard.LeopardException;
import ai.picovoice.leopard.LeopardIOException;
import ai.picovoice.leopard.LeopardInvalidArgumentException;
import ai.picovoice.leopard.LeopardRuntimeException;
import ai.picovoice.leopard.LeopardTranscript;
import ai.picovoice.leopard.Utils;
import java.io.File;
import java.util.Arrays;

public class Leopard {
    private final long libraryHandle;
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();
    public static final String[] VALID_EXTENSIONS = Utils.getValidFileExtensions();

    private Leopard(String accessKey, String modelPath, String libraryPath, boolean enableAutomaticPunctuation) throws LeopardException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new LeopardException(exception);
        }
        this.libraryHandle = this.init(accessKey, modelPath, enableAutomaticPunctuation);
    }

    public void delete() {
        this.delete(this.libraryHandle);
    }

    public LeopardTranscript process(short[] pcm) throws LeopardException {
        return this.process(this.libraryHandle, pcm, pcm.length);
    }

    public LeopardTranscript processFile(String path) throws LeopardException {
        try {
            return this.processFile(this.libraryHandle, path);
        }
        catch (LeopardInvalidArgumentException e) {
            if (path.contains(".")) {
                String extension = path.substring(path.lastIndexOf(".") + 1);
                if (!Arrays.asList(VALID_EXTENSIONS).contains(extension)) {
                    throw new LeopardInvalidArgumentException(String.format("Specified file with extension '%s' is not supported", extension));
                }
            }
            throw e;
        }
    }

    public native int getSampleRate();

    public native String getVersion();

    private native long init(String var1, String var2, boolean var3) throws LeopardException;

    private native void delete(long var1);

    private native LeopardTranscript process(long var1, short[] var3, int var4) throws LeopardException;

    private native LeopardTranscript processFile(long var1, String var3) throws LeopardException;

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private boolean enableAutomaticPunctuation = false;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setEnableAutomaticPunctuation(boolean enableAutomaticPunctuation) {
            this.enableAutomaticPunctuation = enableAutomaticPunctuation;
            return this;
        }

        public Leopard build() throws LeopardException {
            if (!Utils.isEnvironmentSupported()) {
                throw new LeopardRuntimeException("Could not initialize Leopard. Execution environment not currently supported by Leopard Java.");
            }
            if (this.accessKey == null) {
                throw new LeopardInvalidArgumentException("AccessKey must not be null");
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new LeopardInvalidArgumentException("Default library unavailable. Please provide a native Leopard library path (-l <library_path>).");
                }
                this.libraryPath = LIBRARY_PATH;
                if (!new File(this.libraryPath).exists()) {
                    throw new LeopardIOException(String.format("Couldn't find library file at '%s'", this.libraryPath));
                }
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new LeopardInvalidArgumentException("Default model unavailable. Please provide a valid Leopard model path (-m <model_path>).");
                }
                this.modelPath = MODEL_PATH;
                if (!new File(this.modelPath).exists()) {
                    throw new LeopardIOException(String.format("Couldn't find model file at '%s'", this.modelPath));
                }
            }
            return new Leopard(this.accessKey, this.modelPath, this.libraryPath, this.enableAutomaticPunctuation);
        }
    }
}

