/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.leopard;

import ai.picovoice.leopard.LeopardException;
import ai.picovoice.leopard.LeopardIOException;
import ai.picovoice.leopard.LeopardInvalidArgumentException;
import ai.picovoice.leopard.LeopardInvalidStateException;
import ai.picovoice.leopard.LeopardNative;
import ai.picovoice.leopard.LeopardRuntimeException;
import ai.picovoice.leopard.LeopardTranscript;
import ai.picovoice.leopard.Utils;
import java.io.File;
import java.util.List;

public class Leopard {
    public static final String LIBRARY_PATH;
    public static final String MODEL_PATH;
    public static final List<String> VALID_EXTENSIONS;
    private static String sdk;
    private long handle;

    private Leopard(String accessKey, String modelPath, String libraryPath, boolean enableAutomaticPunctuation, boolean enableDiarization) throws LeopardException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new LeopardException(exception);
        }
        LeopardNative.setSdk(sdk);
        this.handle = LeopardNative.init(accessKey, modelPath, enableAutomaticPunctuation, enableDiarization);
    }

    public static void setSdk(String sdk) {
        Leopard.sdk = sdk;
    }

    public void delete() {
        if (this.handle != 0L) {
            LeopardNative.delete(this.handle);
            this.handle = 0L;
        }
    }

    public LeopardTranscript process(short[] pcm) throws LeopardException {
        if (this.handle == 0L) {
            throw new LeopardInvalidStateException("Attempted to call Leopard process after delete.");
        }
        if (pcm == null) {
            throw new LeopardInvalidArgumentException("Passed null frame to Leopard process.");
        }
        return LeopardNative.process(this.handle, pcm, pcm.length);
    }

    public LeopardTranscript processFile(String path) throws LeopardException {
        if (this.handle == 0L) {
            throw new LeopardInvalidStateException("Attempted to call Leopard processFile after delete.");
        }
        if (path == null || path.equals("")) {
            throw new LeopardInvalidArgumentException("Passed null path to Leopard processFile.");
        }
        try {
            return LeopardNative.processFile(this.handle, path);
        }
        catch (LeopardInvalidArgumentException e) {
            String extension;
            if (path.contains(".") && !VALID_EXTENSIONS.contains(extension = path.substring(path.lastIndexOf(".") + 1).toLowerCase())) {
                throw new LeopardInvalidArgumentException(String.format("Specified file with extension '%s' is not supported", extension));
            }
            throw e;
        }
    }

    public int getSampleRate() {
        return LeopardNative.getSampleRate();
    }

    public String getVersion() {
        return LeopardNative.getVersion();
    }

    static {
        sdk = "java";
        LIBRARY_PATH = Utils.getPackagedLibraryPath();
        MODEL_PATH = Utils.getPackagedModelPath();
        VALID_EXTENSIONS = Utils.getValidFileExtensions();
    }

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private boolean enableAutomaticPunctuation = false;
        private boolean enableDiarization = false;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setEnableAutomaticPunctuation(boolean enableAutomaticPunctuation) {
            this.enableAutomaticPunctuation = enableAutomaticPunctuation;
            return this;
        }

        public Builder setEnableDiarization(boolean enableDiarization) {
            this.enableDiarization = enableDiarization;
            return this;
        }

        public Leopard build() throws LeopardException {
            if (!Utils.isEnvironmentSupported()) {
                throw new LeopardRuntimeException("Could not initialize Leopard. Execution environment not currently supported by Leopard Java.");
            }
            if (this.accessKey == null) {
                throw new LeopardInvalidArgumentException("AccessKey must not be null");
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new LeopardInvalidArgumentException("Default library unavailable. Please provide a native Leopard library path (-l <library_path>).");
                }
                this.libraryPath = LIBRARY_PATH;
                if (this.libraryPath == null || !new File(this.libraryPath).exists()) {
                    throw new LeopardIOException(String.format("Couldn't find library file at '%s'", this.libraryPath));
                }
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new LeopardInvalidArgumentException("Default model unavailable. Please provide a valid Leopard model path (-m <model_path>).");
                }
                this.modelPath = MODEL_PATH;
                if (!new File(this.modelPath).exists()) {
                    throw new LeopardIOException(String.format("Couldn't find model file at '%s'", this.modelPath));
                }
            }
            return new Leopard(this.accessKey, this.modelPath, this.libraryPath, this.enableAutomaticPunctuation, this.enableDiarization);
        }
    }
}

