/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.picovoice;

import ai.picovoice.picovoice.PicovoiceActivationException;
import ai.picovoice.picovoice.PicovoiceActivationLimitException;
import ai.picovoice.picovoice.PicovoiceActivationRefusedException;
import ai.picovoice.picovoice.PicovoiceActivationThrottledException;
import ai.picovoice.picovoice.PicovoiceException;
import ai.picovoice.picovoice.PicovoiceIOException;
import ai.picovoice.picovoice.PicovoiceInferenceCallback;
import ai.picovoice.picovoice.PicovoiceInvalidArgumentException;
import ai.picovoice.picovoice.PicovoiceInvalidStateException;
import ai.picovoice.picovoice.PicovoiceKeyException;
import ai.picovoice.picovoice.PicovoiceMemoryException;
import ai.picovoice.picovoice.PicovoiceRuntimeException;
import ai.picovoice.picovoice.PicovoiceStopIterationException;
import ai.picovoice.picovoice.PicovoiceWakeWordCallback;
import ai.picovoice.porcupine.Porcupine;
import ai.picovoice.porcupine.PorcupineActivationException;
import ai.picovoice.porcupine.PorcupineActivationLimitException;
import ai.picovoice.porcupine.PorcupineActivationRefusedException;
import ai.picovoice.porcupine.PorcupineActivationThrottledException;
import ai.picovoice.porcupine.PorcupineException;
import ai.picovoice.porcupine.PorcupineIOException;
import ai.picovoice.porcupine.PorcupineInvalidArgumentException;
import ai.picovoice.porcupine.PorcupineInvalidStateException;
import ai.picovoice.porcupine.PorcupineKeyException;
import ai.picovoice.porcupine.PorcupineMemoryException;
import ai.picovoice.porcupine.PorcupineRuntimeException;
import ai.picovoice.porcupine.PorcupineStopIterationException;
import ai.picovoice.rhino.Rhino;
import ai.picovoice.rhino.RhinoActivationException;
import ai.picovoice.rhino.RhinoActivationLimitException;
import ai.picovoice.rhino.RhinoActivationRefusedException;
import ai.picovoice.rhino.RhinoActivationThrottledException;
import ai.picovoice.rhino.RhinoException;
import ai.picovoice.rhino.RhinoIOException;
import ai.picovoice.rhino.RhinoInvalidArgumentException;
import ai.picovoice.rhino.RhinoInvalidStateException;
import ai.picovoice.rhino.RhinoKeyException;
import ai.picovoice.rhino.RhinoMemoryException;
import ai.picovoice.rhino.RhinoRuntimeException;
import ai.picovoice.rhino.RhinoStopIterationException;

public class Picovoice {
    private Porcupine porcupine;
    private final PicovoiceWakeWordCallback wakeWordCallback;
    private boolean isWakeWordDetected = false;
    private Rhino rhino;
    private final PicovoiceInferenceCallback inferenceCallback;

    public Picovoice(String accessKey, String porcupineLibraryPath, String porcupineModelPath, String keywordPath, float porcupineSensitivity, PicovoiceWakeWordCallback wakeWordCallback, String rhinoLibraryPath, String rhinoModelPath, String contextPath, float rhinoSensitivity, float endpointDurationSec, boolean requireEndpoint, PicovoiceInferenceCallback inferenceCallback) throws PicovoiceException {
        if (wakeWordCallback == null) {
            String message = String.format("Wake word callback is required", new Object[0]);
            throw new PicovoiceInvalidArgumentException(message);
        }
        if (inferenceCallback == null) {
            String message = String.format("Inference callback is required", new Object[0]);
            throw new PicovoiceInvalidArgumentException(message);
        }
        try {
            this.porcupine = new Porcupine.Builder().setAccessKey(accessKey).setLibraryPath(porcupineLibraryPath).setModelPath(porcupineModelPath).setSensitivity(porcupineSensitivity).setKeywordPath(keywordPath).build();
            if (!this.porcupine.getVersion().startsWith("2.1.")) {
                String message = String.format("Expected Porcupine library with version '2.1.x' but received %s", this.porcupine.getVersion());
                throw new PicovoiceException(message);
            }
            this.wakeWordCallback = wakeWordCallback;
            this.rhino = new Rhino.Builder().setAccessKey(accessKey).setLibraryPath(rhinoLibraryPath).setModelPath(rhinoModelPath).setContextPath(contextPath).setSensitivity(rhinoSensitivity).setEndpointDuration(endpointDurationSec).setRequireEndpoint(requireEndpoint).build();
            if (!this.rhino.getVersion().startsWith("2.1.")) {
                String message = String.format("Expected Rhino library with version '2.1.x' but received %s", this.rhino.getVersion());
                throw new PicovoiceException(message);
            }
            if (this.rhino.getFrameLength() != this.porcupine.getFrameLength()) {
                String message = String.format("Incompatible frame lengths for Porcupine and Rhino engines: '%d' and '%d' samples", this.porcupine.getFrameLength(), this.rhino.getFrameLength());
                throw new PicovoiceException(message);
            }
            if (this.rhino.getSampleRate() != this.porcupine.getSampleRate()) {
                String message = String.format("Incompatible sample rates for Porcupine and Rhino engines: '%d' and '%d' Hz", this.porcupine.getSampleRate(), this.rhino.getSampleRate());
                throw new PicovoiceException(message);
            }
            this.inferenceCallback = inferenceCallback;
        }
        catch (PorcupineException | RhinoException e) {
            throw Picovoice.mapToPicovoiceException(e);
        }
    }

    public void delete() {
        if (this.porcupine != null) {
            this.porcupine.delete();
            this.porcupine = null;
        }
        if (this.rhino != null) {
            this.rhino.delete();
            this.rhino = null;
        }
    }

    public void process(short[] pcm) throws PicovoiceException {
        if (this.porcupine == null || this.rhino == null) {
            throw new PicovoiceInvalidStateException("Cannot process frame - resources have been released");
        }
        if (pcm == null) {
            throw new PicovoiceInvalidArgumentException("Passed null frame to Picovoice process.");
        }
        if (pcm.length != this.getFrameLength()) {
            throw new PicovoiceInvalidArgumentException(String.format("Picovoice process requires frames of length %d. Received frame of size %d.", this.getFrameLength(), pcm.length));
        }
        try {
            if (!this.isWakeWordDetected) {
                boolean bl = this.isWakeWordDetected = this.porcupine.process(pcm) == 0;
                if (this.isWakeWordDetected) {
                    this.wakeWordCallback.invoke();
                }
            } else if (this.rhino.process(pcm)) {
                this.inferenceCallback.invoke(this.rhino.getInference());
                this.isWakeWordDetected = false;
            }
        }
        catch (PorcupineException | RhinoException e) {
            throw Picovoice.mapToPicovoiceException(e);
        }
    }

    public String getVersion() {
        return "2.1.0";
    }

    public String getPorcupineVersion() {
        return this.porcupine != null ? this.porcupine.getVersion() : "";
    }

    public String getRhinoVersion() {
        return this.rhino != null ? this.rhino.getVersion() : "";
    }

    public int getFrameLength() {
        return this.porcupine != null ? this.porcupine.getFrameLength() : 0;
    }

    public int getSampleRate() {
        return this.porcupine != null ? this.porcupine.getSampleRate() : 0;
    }

    public String getContextInformation() {
        return this.rhino != null ? this.rhino.getContextInformation() : "";
    }

    private static PicovoiceException mapToPicovoiceException(Exception e) {
        if (e instanceof PorcupineActivationException || e instanceof RhinoActivationException) {
            return new PicovoiceActivationException(e.getMessage(), e);
        }
        if (e instanceof PorcupineActivationLimitException || e instanceof RhinoActivationLimitException) {
            return new PicovoiceActivationLimitException(e.getMessage(), e);
        }
        if (e instanceof PorcupineActivationRefusedException || e instanceof RhinoActivationRefusedException) {
            return new PicovoiceActivationRefusedException(e.getMessage(), e);
        }
        if (e instanceof PorcupineActivationThrottledException || e instanceof RhinoActivationThrottledException) {
            return new PicovoiceActivationThrottledException(e.getMessage(), e);
        }
        if (e instanceof PorcupineInvalidArgumentException || e instanceof RhinoInvalidArgumentException) {
            return new PicovoiceInvalidArgumentException(e.getMessage(), e);
        }
        if (e instanceof PorcupineInvalidStateException || e instanceof RhinoInvalidStateException) {
            return new PicovoiceInvalidStateException(e.getMessage(), e);
        }
        if (e instanceof PorcupineIOException || e instanceof RhinoIOException) {
            return new PicovoiceIOException(e.getMessage(), e);
        }
        if (e instanceof PorcupineKeyException || e instanceof RhinoKeyException) {
            return new PicovoiceKeyException(e.getMessage(), e);
        }
        if (e instanceof PorcupineMemoryException || e instanceof RhinoMemoryException) {
            return new PicovoiceMemoryException(e.getMessage(), e);
        }
        if (e instanceof PorcupineRuntimeException || e instanceof RhinoRuntimeException) {
            return new PicovoiceRuntimeException(e.getMessage(), e);
        }
        if (e instanceof PorcupineStopIterationException || e instanceof RhinoStopIterationException) {
            return new PicovoiceStopIterationException(e.getMessage(), e);
        }
        if (e instanceof PorcupineException || e instanceof RhinoException) {
            return new PicovoiceException(e.getMessage(), e);
        }
        return new PicovoiceException(String.format("Unknown exception: '%s', message: '%s'", e.getClass().getSimpleName(), e.getMessage()), e);
    }

    public static class Builder {
        private String accessKey = null;
        private String porcupineLibraryPath = null;
        private String porcupineModelPath = null;
        private String keywordPath = null;
        private float porcupineSensitivity = 0.5f;
        private PicovoiceWakeWordCallback wakeWordCallback = null;
        private String rhinoLibraryPath = null;
        private String rhinoModelPath = null;
        private String contextPath = null;
        private float rhinoSensitivity = 0.5f;
        private float rhinoEndpointDuration = 1.0f;
        private boolean requireEndpoint = true;
        private PicovoiceInferenceCallback inferenceCallback = null;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setPorcupineLibraryPath(String porcupineLibraryPath) {
            this.porcupineLibraryPath = porcupineLibraryPath;
            return this;
        }

        public Builder setPorcupineModelPath(String porcupineModelPath) {
            this.porcupineModelPath = porcupineModelPath;
            return this;
        }

        public Builder setKeywordPath(String keywordPath) {
            this.keywordPath = keywordPath;
            return this;
        }

        public Builder setPorcupineSensitivity(float porcupineSensitivity) {
            this.porcupineSensitivity = porcupineSensitivity;
            return this;
        }

        public Builder setWakeWordCallback(PicovoiceWakeWordCallback wakeWordCallback) {
            this.wakeWordCallback = wakeWordCallback;
            return this;
        }

        public Builder setRhinoLibraryPath(String rhinoLibraryPath) {
            this.rhinoLibraryPath = rhinoLibraryPath;
            return this;
        }

        public Builder setRhinoModelPath(String rhinoModelPath) {
            this.rhinoModelPath = rhinoModelPath;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setRhinoSensitivity(float rhinoSensitivity) {
            this.rhinoSensitivity = rhinoSensitivity;
            return this;
        }

        public Builder setRhinoEndpointDuration(float rhinoEndpointDuration) {
            this.rhinoEndpointDuration = rhinoEndpointDuration;
            return this;
        }

        public Builder setInferenceCallback(PicovoiceInferenceCallback inferenceCallback) {
            this.inferenceCallback = inferenceCallback;
            return this;
        }

        public Builder setRequireEndpoint(boolean requireEndpoint) {
            this.requireEndpoint = requireEndpoint;
            return this;
        }

        public Picovoice build() throws PicovoiceException {
            return new Picovoice(this.accessKey, this.porcupineLibraryPath, this.porcupineModelPath, this.keywordPath, this.porcupineSensitivity, this.wakeWordCallback, this.rhinoLibraryPath, this.rhinoModelPath, this.contextPath, this.rhinoSensitivity, this.rhinoEndpointDuration, this.requireEndpoint, this.inferenceCallback);
        }
    }
}

