/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.rhino;

import ai.picovoice.rhino.RhinoException;
import ai.picovoice.rhino.RhinoIOException;
import ai.picovoice.rhino.RhinoInference;
import ai.picovoice.rhino.RhinoInvalidArgumentException;
import ai.picovoice.rhino.RhinoInvalidStateException;
import ai.picovoice.rhino.RhinoNative;
import ai.picovoice.rhino.RhinoRuntimeException;
import ai.picovoice.rhino.Utils;
import java.io.File;

public class Rhino {
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();
    private long handle;
    private boolean isFinalized;

    public Rhino(String accessKey, String libraryPath, String modelPath, String contextPath, float sensitivity, float endpointDurationSec, boolean requireEndpoint) throws RhinoException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new RhinoException(exception);
        }
        this.handle = RhinoNative.init(accessKey, modelPath, contextPath, sensitivity, endpointDurationSec, requireEndpoint);
    }

    public void delete() {
        if (this.handle != 0L) {
            RhinoNative.delete(this.handle);
            this.handle = 0L;
        }
    }

    public boolean process(short[] pcm) throws RhinoException {
        if (this.handle == 0L) {
            throw new RhinoInvalidStateException("Attempted to call Rhino process after delete.");
        }
        if (pcm == null) {
            throw new RhinoInvalidArgumentException("Passed null frame to Rhino process.");
        }
        if (pcm.length != this.getFrameLength()) {
            throw new RhinoInvalidArgumentException(String.format("Rhino process requires frames of length %d. Received frame of size %d.", this.getFrameLength(), pcm.length));
        }
        this.isFinalized = RhinoNative.process(this.handle, pcm);
        return this.isFinalized;
    }

    public RhinoInference getInference() throws RhinoException {
        if (this.handle == 0L) {
            throw new RhinoInvalidStateException("Attempted to call Rhino getInference after delete.");
        }
        if (!this.isFinalized) {
            throw new RhinoInvalidStateException("getInference called before Rhino had finalized. Call getInference only after process has returned true");
        }
        return RhinoNative.getInference(this.handle);
    }

    public String getContextInformation() throws RhinoException {
        if (this.handle == 0L) {
            throw new RhinoInvalidStateException("Attempted to call Rhino getContextInformation after delete.");
        }
        return RhinoNative.getContextInfo(this.handle);
    }

    public int getFrameLength() {
        return RhinoNative.getFrameLength();
    }

    public int getSampleRate() {
        return RhinoNative.getSampleRate();
    }

    public String getVersion() {
        return RhinoNative.getVersion();
    }

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private String contextPath = null;
        private float sensitivity = 0.5f;
        private float endpointDuration = 1.0f;
        private boolean requireEndpoint = false;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSensitivity(float sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder setEndpointDuration(float endpointDuration) {
            this.endpointDuration = endpointDuration;
            return this;
        }

        public Builder setRequireEndpoint(boolean requireEndpoint) {
            this.requireEndpoint = requireEndpoint;
            return this;
        }

        public Rhino build() throws RhinoException {
            if (!Utils.isEnvironmentSupported()) {
                throw new RhinoRuntimeException("Could not initialize Rhino. Execution environment not currently supported by Rhino Java.");
            }
            if (this.accessKey == null) {
                throw new RhinoInvalidArgumentException("AccessKey is required for Rhino initialization.");
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new RhinoInvalidArgumentException("Default library unavailable. Please provide a native Rhino library path (-l <library_path>).");
                }
                this.libraryPath = LIBRARY_PATH;
                if (!new File(this.libraryPath).exists()) {
                    throw new RhinoIOException(String.format("Couldn't find library file at '%s'", this.libraryPath));
                }
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new RhinoInvalidArgumentException("Default model unavailable. Please provide a valid Rhino model path (-m <model_path>).");
                }
                this.modelPath = MODEL_PATH;
                if (!new File(this.modelPath).exists()) {
                    throw new RhinoIOException(String.format("Couldn't find model file at '%s'", this.modelPath));
                }
            }
            if (this.contextPath == null) {
                throw new RhinoInvalidArgumentException("No context file provided");
            }
            if (!new File(this.contextPath).exists()) {
                throw new RhinoIOException(String.format("Couldn't find context file at '%s'", this.contextPath));
            }
            if (this.sensitivity < 0.0f || this.sensitivity > 1.0f) {
                throw new RhinoInvalidArgumentException("Sensitivity value should be within [0, 1].");
            }
            if ((double)this.endpointDuration < 0.5 || (double)this.endpointDuration > 5.0) {
                throw new RhinoInvalidArgumentException("Endpoint duration value should be within [0.5, 5.0].");
            }
            return new Rhino(this.accessKey, this.libraryPath, this.modelPath, this.contextPath, this.sensitivity, this.endpointDuration, this.requireEndpoint);
        }
    }
}

