/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.porcupine;

import ai.picovoice.porcupine.PorcupineException;
import ai.picovoice.porcupine.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class Porcupine {
    private final long libraryHandle;
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();
    public static final HashMap<String, String> KEYWORD_PATHS = Utils.getPackagedKeywordPaths();
    public static final Set<String> KEYWORDS = KEYWORD_PATHS.keySet();

    public Porcupine(String libraryPath, String modelPath, String[] keywordPaths, float[] sensitivities) throws PorcupineException {
        try {
            System.load(libraryPath);
            this.libraryHandle = this.init(modelPath, keywordPaths, sensitivities);
        }
        catch (Exception e) {
            throw new PorcupineException(e);
        }
    }

    public void delete() {
        this.delete(this.libraryHandle);
    }

    public int process(short[] pcm) throws PorcupineException {
        try {
            return this.process(this.libraryHandle, pcm);
        }
        catch (Exception e) {
            throw new PorcupineException(e);
        }
    }

    public native String getVersion();

    public native int getFrameLength();

    public native int getSampleRate();

    private native long init(String var1, String[] var2, float[] var3);

    private native void delete(long var1);

    private native int process(long var1, short[] var3);

    public static class Builder {
        private String libraryPath = null;
        private String modelPath = null;
        private String[] keywordPaths = null;
        private String[] keywords = null;
        private float[] sensitivities = null;

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setKeywordPaths(String[] keywordPaths) {
            this.keywordPaths = keywordPaths;
            return this;
        }

        public Builder setKeywordPath(String keywordPaths) {
            this.keywordPaths = new String[]{keywordPaths};
            return this;
        }

        public Builder setKeywords(String[] keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder setKeyword(String keyword) {
            this.keywords = new String[]{keyword};
            return this;
        }

        public Builder setSensitivities(float[] sensitivities) {
            this.sensitivities = sensitivities;
            return this;
        }

        public Builder setSensitivity(float sensitivity) {
            this.sensitivities = new float[]{sensitivity};
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Porcupine build() throws PorcupineException {
            if (!Utils.isEnvironmentSupported()) {
                throw new PorcupineException(new RuntimeException("Could not initialize Porcupine. Execution environment not currently supported by Porcupine Java."));
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) throw new PorcupineException(new IllegalArgumentException("Default library unavailable. Please provide a native Porcupine library path (-l <library_path>)."));
                this.libraryPath = LIBRARY_PATH;
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) throw new PorcupineException(new IllegalArgumentException("Default model unavailable. Please provide a valid Porcupine model path (-m <model_path>)."));
                this.modelPath = MODEL_PATH;
            }
            if (this.keywordPaths != null && this.keywords != null) {
                throw new PorcupineException(new IllegalArgumentException("Both 'keywords' and 'keywordPaths' were set. Only one of the two arguments may be set for initialization."));
            }
            if (this.keywordPaths == null) {
                if (this.keywords == null) {
                    throw new PorcupineException(new IllegalArgumentException("Either 'keywords' or 'keywordPaths' must be set."));
                }
                if (!Utils.isResourcesAvailable()) throw new PorcupineException(new IllegalArgumentException("Default keywords unavailable. Please provide a valid Porcupine keyword path (-kp <keyword_path(s)>)."));
                if (!KEYWORDS.containsAll(Arrays.asList(this.keywords))) throw new PorcupineException(new IllegalArgumentException("One or more keywords are not available by default. Available default keywords are:\n" + String.join((CharSequence)",", KEYWORDS)));
                this.keywordPaths = new String[this.keywords.length];
                for (int i = 0; i < this.keywords.length; ++i) {
                    this.keywordPaths[i] = KEYWORD_PATHS.get(this.keywords[i]);
                }
            }
            if (this.sensitivities == null) {
                this.sensitivities = new float[this.keywordPaths.length];
                Arrays.fill(this.sensitivities, 0.5f);
            }
            if (this.sensitivities.length == this.keywordPaths.length) return new Porcupine(this.libraryPath, this.modelPath, this.keywordPaths, this.sensitivities);
            throw new PorcupineException(new IllegalArgumentException(String.format("Number of keywords (%d) does not match number of sensitivities (%d)", this.keywordPaths.length, this.sensitivities.length)));
        }
    }
}

