/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.porcupine;

import ai.picovoice.porcupine.Porcupine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

class Utils {
    private static final Path RESOURCE_DIRECTORY;
    private static final String ENVIRONMENT_NAME;
    private static final Logger logger;

    Utils() {
    }

    public static boolean isResourcesAvailable() {
        return RESOURCE_DIRECTORY != null;
    }

    public static boolean isEnvironmentSupported() {
        return ENVIRONMENT_NAME != null;
    }

    private static Path getResourceDirectory() {
        Path resourcePath;
        URL resourceURL = Porcupine.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            resourcePath = Paths.get(resourceURL.toURI());
        }
        catch (URISyntaxException e) {
            resourcePath = Paths.get(resourceURL.getPath(), new String[0]);
        }
        if (resourcePath.toString().endsWith(".jar")) {
            try {
                resourcePath = Utils.extractResources(resourcePath);
            }
            catch (IOException e) {
                logger.severe("Failed to extract resources from Porcupine jar.");
                e.printStackTrace();
                return null;
            }
        }
        return resourcePath.resolve("porcupine");
    }

    private static Path extractResources(Path jarPath) throws IOException {
        String extractionDirName = jarPath.getFileName().toString().replace(".jar", "");
        String systemTempDir = System.getProperty("java.io.tmpdir");
        Path resourceDirectoryPath = new File(systemTempDir, extractionDirName).toPath();
        if (!Files.exists(resourceDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectory(resourceDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.severe("Failed to create extraction directory at " + jarPath.toString());
                e.printStackTrace();
                resourceDirectoryPath = new File(systemTempDir).toPath();
            }
        }
        JarFile jf = new JarFile(jarPath.toFile());
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.startsWith("porcupine")) continue;
            if (jarEntry.isDirectory()) {
                Path dstPath = resourceDirectoryPath.resolve(jarEntryName);
                if (dstPath.toFile().exists()) continue;
                Files.createDirectory(dstPath, new FileAttribute[0]);
                continue;
            }
            Path file = resourceDirectoryPath.resolve(jarEntryName);
            InputStream is = jf.getInputStream(jarEntry);
            try {
                Files.copy(is, file, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return resourceDirectoryPath;
    }

    private static String getEnvironmentName() throws RuntimeException {
        String arch = System.getProperty("os.arch");
        if (arch.equals("amd64") || arch.equals("x86_64")) {
            String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if (os.contains("mac") || os.contains("darwin")) {
                return "mac";
            }
            if (os.contains("win")) {
                return "windows";
            }
            if (os.contains("linux")) {
                return "linux";
            }
            logger.severe("Execution environment not supported. Porcupine Java is supported on MacOS, Linux and Windows");
            return null;
        }
        logger.severe(String.format("Platform architecture (%s) not supported. Porcupine Java is only supported on amd64 and x86_64 architectures.", arch));
        return null;
    }

    public static String getPackagedModelPath() {
        return RESOURCE_DIRECTORY.resolve("lib/common/porcupine_params.pv").toString();
    }

    public static HashMap<String, String> getPackagedKeywordPaths() {
        HashMap<String, String> keywordPaths = new HashMap<String, String>();
        Path keywordFileDir = RESOURCE_DIRECTORY.resolve("resources/keyword_files").resolve(ENVIRONMENT_NAME);
        File[] keywordFiles = keywordFileDir.toFile().listFiles();
        if (keywordFiles == null || keywordFiles.length == 0) {
            logger.severe("Couldn't find any Porcupine keywords in jar.");
            return keywordPaths;
        }
        for (File keywordFile : keywordFiles) {
            keywordPaths.put(keywordFile.getName().split("_")[0], keywordFile.getAbsolutePath());
        }
        return keywordPaths;
    }

    public static String getPackagedLibraryPath() {
        if (ENVIRONMENT_NAME == null) {
            return null;
        }
        switch (ENVIRONMENT_NAME) {
            case "windows": {
                return RESOURCE_DIRECTORY.resolve("lib/java/windows/amd64/pv_porcupine_jni.dll").toString();
            }
            case "mac": {
                return RESOURCE_DIRECTORY.resolve("lib/java/mac/x86_64/libpv_porcupine_jni.dylib").toString();
            }
            case "linux": {
                return RESOURCE_DIRECTORY.resolve("lib/java/linux/x86_64/libpv_porcupine_jni.so").toString();
            }
        }
        return null;
    }

    static {
        logger = Logger.getLogger("global");
        RESOURCE_DIRECTORY = Utils.getResourceDirectory();
        ENVIRONMENT_NAME = Utils.getEnvironmentName();
    }
}

