/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.porcupine;

import ai.picovoice.porcupine.PorcupineException;
import ai.picovoice.porcupine.PorcupineInvalidArgumentException;
import ai.picovoice.porcupine.PorcupineNative;
import ai.picovoice.porcupine.PorcupineRuntimeException;
import ai.picovoice.porcupine.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Porcupine {
    public static final String LIBRARY_PATH;
    public static final String MODEL_PATH;
    public static final HashMap<BuiltInKeyword, String> BUILT_IN_KEYWORD_PATHS;
    private static String sdk;
    private long handle;

    public static void setSdk(String sdk) {
        Porcupine.sdk = sdk;
    }

    public Porcupine(String accessKey, String libraryPath, String modelPath, String[] keywordPaths, float[] sensitivities) throws PorcupineException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new PorcupineException(exception);
        }
        PorcupineNative.setSdk(sdk);
        this.handle = PorcupineNative.init(accessKey, modelPath, keywordPaths, sensitivities);
    }

    public void delete() {
        if (this.handle != 0L) {
            PorcupineNative.delete(this.handle);
            this.handle = 0L;
        }
    }

    public int process(short[] pcm) throws PorcupineException {
        if (this.handle == 0L) {
            throw new PorcupineException(new IllegalStateException("Attempted to call Porcupine process after delete."));
        }
        if (pcm == null) {
            throw new PorcupineException(new IllegalArgumentException("Passed null frame to Porcupine process."));
        }
        if (pcm.length != this.getFrameLength()) {
            throw new PorcupineException(new IllegalArgumentException(String.format("Porcupine process requires frames of length %d. Received frame of size %d.", this.getFrameLength(), pcm.length)));
        }
        return PorcupineNative.process(this.handle, pcm);
    }

    public String getVersion() {
        return PorcupineNative.getVersion();
    }

    public int getFrameLength() {
        return PorcupineNative.getFrameLength();
    }

    public int getSampleRate() {
        return PorcupineNative.getSampleRate();
    }

    static {
        sdk = "java";
        LIBRARY_PATH = Utils.getPackagedLibraryPath();
        MODEL_PATH = Utils.getPackagedModelPath();
        BUILT_IN_KEYWORD_PATHS = Utils.getPackagedKeywordPaths();
    }

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private String[] keywordPaths = null;
        private BuiltInKeyword[] keywords = null;
        private float[] sensitivities = null;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setKeywordPaths(String[] keywordPaths) {
            this.keywordPaths = keywordPaths;
            return this;
        }

        public Builder setKeywordPath(String keywordPaths) {
            this.keywordPaths = new String[]{keywordPaths};
            return this;
        }

        public Builder setBuiltInKeywords(BuiltInKeyword[] keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder setBuiltInKeyword(BuiltInKeyword keyword) {
            this.keywords = new BuiltInKeyword[]{keyword};
            return this;
        }

        public Builder setSensitivities(float[] sensitivities) {
            this.sensitivities = sensitivities;
            return this;
        }

        public Builder setSensitivity(float sensitivity) {
            this.sensitivities = new float[]{sensitivity};
            return this;
        }

        public Porcupine build() throws PorcupineException {
            if (!Utils.isEnvironmentSupported()) {
                throw new PorcupineRuntimeException("Could not initialize Porcupine. Execution environment not currently supported by Porcupine Java.");
            }
            if (this.accessKey == null) {
                throw new PorcupineInvalidArgumentException("AccessKey is required for Porcupine initialization.");
            }
            if (this.libraryPath == null) {
                if (Utils.isResourcesAvailable()) {
                    this.libraryPath = LIBRARY_PATH;
                } else {
                    throw new PorcupineInvalidArgumentException("Default library unavailable. Please provide a native Porcupine library path (-l <library_path>).");
                }
            }
            if (this.modelPath == null) {
                if (Utils.isResourcesAvailable()) {
                    this.modelPath = MODEL_PATH;
                } else {
                    throw new PorcupineInvalidArgumentException("Default model unavailable. Please provide a valid Porcupine model path (-m <model_path>).");
                }
            }
            if (this.keywordPaths != null && this.keywords != null) {
                throw new PorcupineInvalidArgumentException("Both 'keywords' and 'keywordPaths' were set. Only one of the two arguments may be set for initialization.");
            }
            if (this.keywordPaths == null) {
                if (this.keywords == null) {
                    throw new PorcupineInvalidArgumentException("Either 'keywords' or 'keywordPaths' must be set.");
                }
                if (Utils.isResourcesAvailable()) {
                    this.keywordPaths = new String[this.keywords.length];
                    for (int i = 0; i < this.keywords.length; ++i) {
                        this.keywordPaths[i] = BUILT_IN_KEYWORD_PATHS.get((Object)this.keywords[i]);
                    }
                } else {
                    throw new PorcupineInvalidArgumentException("BuiltIn keywords unavailable. Please provide a valid Porcupine keyword path.");
                }
            }
            if (this.sensitivities == null) {
                this.sensitivities = new float[this.keywordPaths.length];
                Arrays.fill(this.sensitivities, 0.5f);
            }
            if (this.sensitivities.length != this.keywordPaths.length) {
                throw new PorcupineInvalidArgumentException(String.format("Number of keywords (%d) does not match number of sensitivities (%d)", this.keywordPaths.length, this.sensitivities.length));
            }
            return new Porcupine(this.accessKey, this.libraryPath, this.modelPath, this.keywordPaths, this.sensitivities);
        }
    }

    public static enum BuiltInKeyword {
        ALEXA,
        AMERICANO,
        BLUEBERRY,
        BUMBLEBEE,
        COMPUTER,
        GRAPEFRUIT,
        GRASSHOPPER,
        HEY_GOOGLE,
        HEY_SIRI,
        JARVIS,
        OK_GOOGLE,
        PICOVOICE,
        PORCUPINE,
        TERMINATOR;


        public static Stream<BuiltInKeyword> stream() {
            return Stream.of(BuiltInKeyword.values());
        }

        public static String options() {
            return BuiltInKeyword.stream().map(v -> v.name()).collect(Collectors.joining(","));
        }
    }
}

