/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.rhino;

import ai.picovoice.rhino.RhinoException;
import ai.picovoice.rhino.RhinoInference;
import ai.picovoice.rhino.Utils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;

public class Rhino {
    private final long libraryHandle;
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();

    public Rhino(String libraryPath, String modelPath, String contextPath, float sensitivity) throws RhinoException {
        try {
            System.load(libraryPath);
            this.libraryHandle = this.init(modelPath, contextPath, sensitivity);
        }
        catch (Exception e) {
            throw new RhinoException(e);
        }
    }

    public void delete() {
        this.delete(this.libraryHandle);
    }

    public boolean process(short[] pcm) throws RhinoException {
        try {
            return this.process(this.libraryHandle, pcm);
        }
        catch (Exception e) {
            throw new RhinoException(e);
        }
    }

    public RhinoInference getInference() throws RhinoException {
        try {
            RhinoInference inference;
            boolean isUnderstood = this.isUnderstood(this.libraryHandle);
            if (isUnderstood) {
                String intentPacked = this.getIntent(this.libraryHandle);
                String[] parts = intentPacked.split(",");
                if (parts.length == 0) {
                    throw new RhinoException(String.format("Failed to retrieve intent from '%s'.", intentPacked));
                }
                LinkedHashMap<String, String> slots = new LinkedHashMap<String, String>();
                for (int i = 1; i < parts.length; ++i) {
                    String[] slotAndValue = parts[i].split(":");
                    if (slotAndValue.length != 2) {
                        throw new RhinoException(String.format("Failed to retrieve intent from '%s'.", intentPacked));
                    }
                    slots.put(slotAndValue[0], slotAndValue[1]);
                }
                inference = new RhinoInference(true, parts[0], slots);
            } else {
                inference = new RhinoInference(false, null, null);
            }
            this.reset(this.libraryHandle);
            return inference;
        }
        catch (Exception e) {
            throw new RhinoException(e);
        }
    }

    public String getContextInformation() {
        return this.getContextInfo(this.libraryHandle);
    }

    public native int getFrameLength();

    public native int getSampleRate();

    public native String getVersion();

    private native long init(String var1, String var2, float var3);

    private native void delete(long var1);

    private native boolean process(long var1, short[] var3);

    private native boolean isUnderstood(long var1);

    private native String getIntent(long var1);

    private native boolean reset(long var1);

    private native String getContextInfo(long var1);

    public static class Builder {
        private String libraryPath = null;
        private String modelPath = null;
        private String contextPath = null;
        private float sensitivity = 0.5f;

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSensitivity(float sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Rhino build() throws RhinoException {
            if (!Utils.isEnvironmentSupported()) {
                throw new RhinoException(new RuntimeException("Could not initialize Rhino. Execution environment not currently supported by Rhino Java."));
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new RhinoException(new IllegalArgumentException("Default library unavailable. Please provide a native Rhino library path (-l <library_path>)."));
                }
                this.libraryPath = LIBRARY_PATH;
                if (!new File(this.libraryPath).exists()) {
                    throw new RhinoException(new IOException(String.format("Couldn't find library file at '%s'", this.libraryPath)));
                }
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new RhinoException(new IllegalArgumentException("Default model unavailable. Please provide a valid Rhino model path (-m <model_path>)."));
                }
                this.modelPath = MODEL_PATH;
                if (!new File(this.modelPath).exists()) {
                    throw new RhinoException(new IOException(String.format("Couldn't find model file at '%s'", this.modelPath)));
                }
            }
            if (this.contextPath == null) {
                throw new RhinoException(new IllegalArgumentException("No context file provided."));
            }
            if (!new File(this.contextPath).exists()) {
                throw new RhinoException(new IOException(String.format("Couldn't find context file at '%s'", this.contextPath)));
            }
            if (this.sensitivity < 0.0f || this.sensitivity > 1.0f) {
                throw new RhinoException(new IllegalArgumentException("Sensitivity value should be within [0, 1]."));
            }
            return new Rhino(this.libraryPath, this.modelPath, this.contextPath, this.sensitivity);
        }
    }
}

