/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.rhino;

import ai.picovoice.rhino.RhinoException;
import ai.picovoice.rhino.RhinoIOException;
import ai.picovoice.rhino.RhinoInference;
import ai.picovoice.rhino.RhinoInvalidArgumentException;
import ai.picovoice.rhino.RhinoRuntimeException;
import ai.picovoice.rhino.Utils;
import java.io.File;
import java.util.LinkedHashMap;

public class Rhino {
    private final long libraryHandle;
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();

    public Rhino(String accessKey, String libraryPath, String modelPath, String contextPath, float sensitivity, float endpointDurationSec, boolean requireEndpoint) throws RhinoException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new RhinoException(exception);
        }
        this.libraryHandle = this.init(accessKey, modelPath, contextPath, sensitivity, endpointDurationSec, requireEndpoint);
    }

    public void delete() {
        this.delete(this.libraryHandle);
    }

    public boolean process(short[] pcm) throws RhinoException {
        return this.process(this.libraryHandle, pcm);
    }

    public RhinoInference getInference() throws RhinoException {
        RhinoInference inference;
        boolean isUnderstood = this.isUnderstood(this.libraryHandle);
        if (isUnderstood) {
            String intentPacked = this.getIntent(this.libraryHandle);
            String[] parts = intentPacked.split(",");
            if (parts.length == 0) {
                throw new RhinoException(String.format("Failed to retrieve intent from '%s'.", intentPacked));
            }
            LinkedHashMap<String, String> slots = new LinkedHashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String[] slotAndValue = parts[i].split(":");
                if (slotAndValue.length != 2) {
                    throw new RhinoException(String.format("Failed to retrieve intent from '%s'.", intentPacked));
                }
                slots.put(slotAndValue[0], slotAndValue[1]);
            }
            inference = new RhinoInference(true, parts[0], slots);
        } else {
            inference = new RhinoInference(false, null, null);
        }
        this.reset(this.libraryHandle);
        return inference;
    }

    public String getContextInformation() {
        return this.getContextInfo(this.libraryHandle);
    }

    public native int getFrameLength();

    public native int getSampleRate();

    public native String getVersion();

    private native long init(String var1, String var2, String var3, float var4, float var5, boolean var6);

    private native void delete(long var1);

    private native boolean process(long var1, short[] var3);

    private native boolean isUnderstood(long var1);

    private native String getIntent(long var1);

    private native boolean reset(long var1);

    private native String getContextInfo(long var1);

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private String contextPath = null;
        private float sensitivity = 0.5f;
        private float endpointDuration = 1.0f;
        private boolean requireEndpoint = false;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSensitivity(float sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder SetEndpointDuration(float endpointDuration) {
            this.endpointDuration = endpointDuration;
            return this;
        }

        public Builder setRequireEndpoint(boolean requireEndpoint) {
            this.requireEndpoint = requireEndpoint;
            return this;
        }

        public Rhino build() throws RhinoException {
            if (!Utils.isEnvironmentSupported()) {
                throw new RhinoRuntimeException("Could not initialize Rhino. Execution environment not currently supported by Rhino Java.");
            }
            if (this.accessKey == null) {
                throw new RhinoInvalidArgumentException("AccessKey is required for Rhino initialization.");
            }
            if (this.libraryPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new RhinoInvalidArgumentException("Default library unavailable. Please provide a native Rhino library path (-l <library_path>).");
                }
                this.libraryPath = LIBRARY_PATH;
                if (!new File(this.libraryPath).exists()) {
                    throw new RhinoIOException(String.format("Couldn't find library file at '%s'", this.libraryPath));
                }
            }
            if (this.modelPath == null) {
                if (!Utils.isResourcesAvailable()) {
                    throw new RhinoInvalidArgumentException("Default model unavailable. Please provide a valid Rhino model path (-m <model_path>).");
                }
                this.modelPath = MODEL_PATH;
                if (!new File(this.modelPath).exists()) {
                    throw new RhinoIOException(String.format("Couldn't find model file at '%s'", this.modelPath));
                }
            }
            if (this.contextPath == null) {
                throw new RhinoInvalidArgumentException("No context file provided");
            }
            if (!new File(this.contextPath).exists()) {
                throw new RhinoIOException(String.format("Couldn't find context file at '%s'", this.contextPath));
            }
            if (this.sensitivity < 0.0f || this.sensitivity > 1.0f) {
                throw new RhinoInvalidArgumentException("Sensitivity value should be within [0, 1].");
            }
            if ((double)this.endpointDuration < 0.5 || (double)this.endpointDuration > 5.0) {
                throw new RhinoInvalidArgumentException("Endpoint duration value should be within [0.5, 5.0].");
            }
            return new Rhino(this.accessKey, this.libraryPath, this.modelPath, this.contextPath, this.sensitivity, this.endpointDuration, this.requireEndpoint);
        }
    }
}

