/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.rhino;

import ai.picovoice.rhino.Rhino;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

class Utils {
    private static final Path RESOURCE_DIRECTORY;
    private static final String ENVIRONMENT_NAME;
    private static final String ARCHITECTURE;
    private static final Logger logger;

    Utils() {
    }

    public static boolean isResourcesAvailable() {
        return RESOURCE_DIRECTORY != null;
    }

    public static boolean isEnvironmentSupported() {
        return ENVIRONMENT_NAME != null;
    }

    private static Path getResourceDirectory() throws RuntimeException {
        Path resourcePath;
        URL resourceURL = Rhino.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            resourcePath = Paths.get(resourceURL.toURI());
        }
        catch (URISyntaxException e) {
            resourcePath = Paths.get(resourceURL.getPath(), new String[0]);
        }
        if (resourcePath.toString().endsWith(".jar")) {
            try {
                resourcePath = Utils.extractResources(resourcePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to extract resources from Rhino JAR.");
            }
        }
        return resourcePath.resolve("rhino");
    }

    private static Path extractResources(Path jarPath) throws IOException {
        String extractionDirName = jarPath.getFileName().toString().replace(".jar", "");
        String systemTempDir = System.getProperty("java.io.tmpdir");
        Path resourceDirectoryPath = new File(systemTempDir, extractionDirName).toPath();
        if (!Files.exists(resourceDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectory(resourceDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.severe("Failed to create extraction directory at " + jarPath.toString());
                e.printStackTrace();
                resourceDirectoryPath = new File(systemTempDir).toPath();
            }
        }
        JarFile jf = new JarFile(jarPath.toFile());
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.startsWith("rhino")) continue;
            if (jarEntry.isDirectory()) {
                Path dstPath = resourceDirectoryPath.resolve(jarEntryName);
                if (dstPath.toFile().exists()) continue;
                Files.createDirectory(dstPath, new FileAttribute[0]);
                continue;
            }
            Path file = resourceDirectoryPath.resolve(jarEntryName);
            InputStream is = jf.getInputStream(jarEntry);
            try {
                Files.copy(is, file, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return resourceDirectoryPath;
    }

    public static String getEnvironmentName() throws RuntimeException {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin")) {
            return "mac";
        }
        if (os.contains("win")) {
            return "windows";
        }
        if (os.contains("linux")) {
            String arch = System.getProperty("os.arch");
            if (arch.equals("arm") || arch.equals("aarch64")) {
                String cpuPart;
                switch (cpuPart = Utils.getCpuPart()) {
                    case "0xd03": 
                    case "0xd08": 
                    case "0xd0b": {
                        return "raspberry-pi";
                    }
                }
                throw new RuntimeException(String.format("Execution environment not supported. Rhino Java does not support CPU Part (%s).", cpuPart));
            }
            return "linux";
        }
        throw new RuntimeException("Execution environment not supported. Rhino Java is supported on MacOS, Linux and Windows");
    }

    private static String getArchitecture() throws RuntimeException {
        boolean isX86_64;
        String arch = System.getProperty("os.arch");
        boolean isArm = arch.equals("arm") || arch.equals("aarch64");
        boolean bl = isX86_64 = arch.equals("amd64") || arch.equals("x86_64");
        if (ENVIRONMENT_NAME.equals("mac")) {
            if (isArm) {
                return "arm64";
            }
            if (isX86_64) {
                return "x86_64";
            }
        } else if (ENVIRONMENT_NAME.equals("windows")) {
            if (isX86_64) {
                return "amd64";
            }
        } else if (ENVIRONMENT_NAME.equals("linux")) {
            if (isX86_64) {
                return "x86_64";
            }
        } else if (isArm) {
            String cpuPart = Utils.getCpuPart();
            String archInfo = arch.equals("aarch64") ? "-aarch64" : "";
            switch (cpuPart) {
                case "0xd03": {
                    return "cortex-a53" + archInfo;
                }
                case "0xd08": {
                    return "cortex-a72" + archInfo;
                }
                case "0xd0b": {
                    return "cortex-a76" + archInfo;
                }
            }
            throw new RuntimeException(String.format("Environment (%s) with CPU Part (%s) is not supported by Porcupine.", ENVIRONMENT_NAME, cpuPart));
        }
        throw new RuntimeException(String.format("Environment (%s) with architecture (%s) is not supported by Porcupine.", ENVIRONMENT_NAME, arch));
    }

    private static String getCpuPart() throws RuntimeException {
        try {
            return Files.lines(Paths.get("/proc/cpuinfo", new String[0])).filter(line -> line.startsWith("CPU part")).map(line -> line.substring(line.lastIndexOf(" ") + 1)).findFirst().orElse("");
        }
        catch (IOException e) {
            throw new RuntimeException("Rhino failed to get get CPU information.");
        }
    }

    public static String getPackagedModelPath() {
        return RESOURCE_DIRECTORY.resolve("lib/common/rhino_params.pv").toString();
    }

    public static String getPackagedLibraryPath() {
        switch (ENVIRONMENT_NAME) {
            case "windows": {
                return RESOURCE_DIRECTORY.resolve("lib/java/windows/amd64/pv_rhino_jni.dll").toString();
            }
            case "mac": {
                return RESOURCE_DIRECTORY.resolve("lib/java/mac").resolve(ARCHITECTURE).resolve("libpv_rhino_jni.dylib").toString();
            }
            case "raspberry-pi": 
            case "linux": {
                return RESOURCE_DIRECTORY.resolve("lib/java").resolve(ENVIRONMENT_NAME).resolve(ARCHITECTURE).resolve("libpv_rhino_jni.so").toString();
            }
        }
        return null;
    }

    static {
        logger = Logger.getLogger("global");
        RESOURCE_DIRECTORY = Utils.getResourceDirectory();
        ENVIRONMENT_NAME = Utils.getEnvironmentName();
        ARCHITECTURE = Utils.getArchitecture();
    }
}

