/*
 * Decompiled with CFR 0.152.
 */
package ai.pipecat.client.gemini_live_websocket;

import android.media.AudioRecord;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lai/pipecat/client/gemini_live_websocket/AudioIn;", "", "sampleRateHz", "", "onAudioCaptured", "Lkotlin/Function1;", "", "", "onError", "", "onStopped", "Lkotlin/Function0;", "initialMicEnabled", "", "<init>", "(ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Z)V", "thread", "Ljava/lang/Thread;", "mute", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stop", "value", "muted", "getMuted", "()Z", "setMuted", "(Z)V", "pipecat-client-android-gemini-live-websocket_release"})
public final class AudioIn {
    @NotNull
    private final Thread thread;
    @NotNull
    private final AtomicBoolean mute;
    @NotNull
    private final AtomicBoolean stop;

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public AudioIn(int sampleRateHz, @NotNull Function1<? super byte[], Unit> onAudioCaptured, @NotNull Function1<? super Throwable, Unit> onError, @NotNull Function0<Unit> onStopped, boolean initialMicEnabled) {
        Intrinsics.checkNotNullParameter(onAudioCaptured, (String)"onAudioCaptured");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter(onStopped, (String)"onStopped");
        this.mute = new AtomicBoolean(!initialMicEnabled);
        this.stop = new AtomicBoolean(false);
        this.thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"AudioIn", (int)0, () -> AudioIn._init_$lambda$1(this, sampleRateHz, onAudioCaptured, onError, onStopped), (int)23, null);
    }

    public final void stop() {
        this.stop.set(true);
    }

    public final boolean getMuted() {
        return this.mute.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMuted(boolean value) {
        AtomicBoolean atomicBoolean = this.mute;
        synchronized (atomicBoolean) {
            boolean bl = false;
            this.mute.set(value);
            AtomicBoolean atomicBoolean2 = this.mute;
            Intrinsics.checkNotNull((Object)atomicBoolean2, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)atomicBoolean2).notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$1(AudioIn this$0, int $sampleRateHz, Function1 $onAudioCaptured, Function1 $onError, Function0 $onStopped) {
        try {
            while (!this$0.stop.get()) {
                while (this$0.mute.get() && !this$0.stop.get()) {
                    AtomicBoolean atomicBoolean = this$0.mute;
                    synchronized (atomicBoolean) {
                        boolean $i$a$-synchronized-AudioIn$1$22 = false;
                        AtomicBoolean atomicBoolean2 = this$0.mute;
                        Intrinsics.checkNotNull((Object)atomicBoolean2, (String)"null cannot be cast to non-null type java.lang.Object");
                        ((Object)atomicBoolean2).wait();
                        Unit $i$a$-synchronized-AudioIn$1$22 = Unit.INSTANCE;
                    }
                }
                if (this$0.stop.get()) {
                    break;
                }
                int frameSizeBytes = 2;
                int bufferBytes = frameSizeBytes * $sampleRateHz * 100 / 1000;
                AudioRecord record = new AudioRecord(7, $sampleRateHz, 16, 2, bufferBytes);
                try {
                    record.startRecording();
                    byte[] buf = new byte[bufferBytes];
                    while (!this$0.stop.get() && !this$0.mute.get()) {
                        int readResult = record.read(buf, 0, buf.length, 0);
                        if (readResult <= 0) {
                            throw new RuntimeException("record.read returned " + readResult);
                        }
                        byte[] byArray = Arrays.copyOf(buf, readResult);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                        $onAudioCaptured.invoke((Object)byArray);
                    }
                }
                finally {
                    record.release();
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"AudioIn", (String)"Exception when capturing audio", (Throwable)e);
            $onError.invoke((Object)e);
        }
        finally {
            $onStopped.invoke();
        }
        return Unit.INSTANCE;
    }
}

