/*
 * Decompiled with CFR 0.152.
 */
package ai.pipecat.client.gemini_live_websocket;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.util.Log;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/pipecat/client/gemini_live_websocket/AudioOut;", "", "sampleRateHz", "", "onAudioLevelUpdate", "Lkotlin/Function1;", "", "", "<init>", "(ILkotlin/jvm/functions/Function1;)V", "queueLock", "Ljava/lang/Object;", "queue", "Ljava/util/LinkedList;", "", "stopped", "", "calculateAudioLevel", "pcmData", "write", "samples", "stop", "interrupt", "pipecat-client-android-gemini-live-websocket_release"})
public final class AudioOut {
    @NotNull
    private final Object queueLock;
    @NotNull
    private final LinkedList<byte[]> queue;
    private boolean stopped;

    public AudioOut(int sampleRateHz, @NotNull Function1<? super Float, Unit> onAudioLevelUpdate) {
        Intrinsics.checkNotNullParameter(onAudioLevelUpdate, (String)"onAudioLevelUpdate");
        this.queueLock = new Object();
        this.queue = new LinkedList();
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"AudioOut", (int)0, () -> AudioOut._init_$lambda$1(sampleRateHz, this, onAudioLevelUpdate), (int)23, null);
    }

    private final float calculateAudioLevel(byte[] pcmData) {
        double sumSquares = 0.0;
        int numSamples = pcmData.length / 2;
        for (int i = 0; i < numSamples; ++i) {
            int low = pcmData[i * 2] & 0xFF;
            int high = pcmData[i * 2 + 1] & 0xFF;
            short sample = (short)(high << 8 | low);
            double sampleValue = sample;
            sumSquares += sampleValue * sampleValue;
        }
        double rms = Math.sqrt(sumSquares / (double)numSamples);
        return RangesKt.coerceIn((float)((float)(rms / 32768.0)), (float)0.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull byte[] samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            if (!this.stopped) {
                this.queue.offer(samples);
                this.queueLock.notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            if (!this.stopped) {
                this.queue.offer(null);
                this.queueLock.notifyAll();
                this.stopped = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            this.queue.clear();
            if (this.stopped) {
                this.queue.add(null);
            }
            this.queueLock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$1(int $sampleRateHz, AudioOut this$0, Function1 $onAudioLevelUpdate) {
        AudioFormat audioFormat = new AudioFormat.Builder().setSampleRate($sampleRateHz).setEncoding(2).setChannelMask(4).build();
        int frameSizeBytes = 2;
        int bufferBytes = frameSizeBytes * $sampleRateHz * 100 / 1000;
        Log.i((String)"AudioOut", (String)("Creating AudioOut: sampleRateHz = " + $sampleRateHz + ", bufferBytes = " + bufferBytes));
        AudioTrack track = new AudioTrack(new AudioAttributes.Builder().setUsage(2).setContentType(1).build(), audioFormat, frameSizeBytes * $sampleRateHz * 100 / 1000, 1, 0);
        try {
            track.play();
            block7: while (true) {
                byte[] byArray;
                Object object = this$0.queueLock;
                synchronized (object) {
                    boolean bl = false;
                    while (this$0.queue.isEmpty()) {
                        this$0.queueLock.wait();
                    }
                    byArray = this$0.queue.removeFirst();
                }
                byte[] item = byArray;
                if (item == null) {
                    Log.i((String)"AudioOut", (String)"Terminating AudioOut");
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                $onAudioLevelUpdate.invoke((Object)Float.valueOf(this$0.calculateAudioLevel(item)));
                int writePtr = 0;
                while (true) {
                    if (writePtr >= item.length) continue block7;
                    int writeRes = track.write(item, 0, item.length);
                    if (writeRes <= 0) {
                        throw new RuntimeException("write returned " + writeRes);
                    }
                    writePtr += item.length;
                }
                break;
            }
        }
        finally {
            track.release();
        }
    }
}

