/*
 * Decompiled with CFR 0.152.
 */
package ai.pipecat.client.gemini_live_websocket;

import ai.pipecat.client.gemini_live_websocket.AppendedMessage;
import ai.pipecat.client.gemini_live_websocket.AudioIn;
import ai.pipecat.client.gemini_live_websocket.AudioOut;
import ai.pipecat.client.gemini_live_websocket.ClientContentRequest;
import ai.pipecat.client.gemini_live_websocket.GeminiClientKt;
import ai.pipecat.client.gemini_live_websocket.IncomingMessage;
import ai.pipecat.client.gemini_live_websocket.InlineData;
import ai.pipecat.client.gemini_live_websocket.RealtimeInputRequest;
import ai.pipecat.client.gemini_live_websocket.SetupRequest;
import ai.pipecat.client.gemini_live_websocket.TurnPart;
import ai.pipecat.client.types.Value;
import android.annotation.SuppressLint;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0004\u0017\u0018\u0019\u001aBM\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0005R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\b\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient;", "", "onSendUserMessage", "Lkotlin/Function1;", "Lai/pipecat/client/gemini_live_websocket/AppendedMessage;", "", "onClose", "Lkotlin/Function0;", "setMicMuted", "", "isMicMuted", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "muted", "micMuted", "getMicMuted", "()Z", "(Z)V", "sendUserMessage", "role", "", "content", "close", "Config", "Listener", "ClientThreadEvent", "Companion", "pipecat-client-android-gemini-live-websocket_release"})
public final class GeminiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<AppendedMessage, Unit> onSendUserMessage;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final Function1<Boolean, Unit> setMicMuted;
    @NotNull
    private final Function0<Boolean> isMicMuted;

    private GeminiClient(Function1<? super AppendedMessage, Unit> onSendUserMessage, Function0<Unit> onClose, Function1<? super Boolean, Unit> setMicMuted, Function0<Boolean> isMicMuted) {
        this.onSendUserMessage = onSendUserMessage;
        this.onClose = onClose;
        this.setMicMuted = setMicMuted;
        this.isMicMuted = isMicMuted;
    }

    public final boolean getMicMuted() {
        return (Boolean)this.isMicMuted.invoke();
    }

    public final void setMicMuted(boolean muted) {
        this.setMicMuted.invoke((Object)muted);
    }

    public final void sendUserMessage(@NotNull String role, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.onSendUserMessage.invoke((Object)new AppendedMessage(role, content));
    }

    public final void close() {
        this.onClose.invoke();
    }

    public /* synthetic */ GeminiClient(Function1 onSendUserMessage, Function0 onClose, Function1 setMicMuted, Function0 isMicMuted, DefaultConstructorMarker $constructor_marker) {
        this((Function1<? super AppendedMessage, Unit>)onSendUserMessage, (Function0<Unit>)onClose, (Function1<? super Boolean, Unit>)setMicMuted, (Function0<Boolean>)isMicMuted);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u0082\u0001\u0007\t\n\u000b\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "", "SendAudioData", "SendUserMessage", "Stop", "WebsocketClosed", "WebsocketFailed", "WebsocketMessage", "SetMicMute", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$SendAudioData;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$SendUserMessage;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$SetMicMute;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$Stop;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$WebsocketClosed;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$WebsocketFailed;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$WebsocketMessage;", "pipecat-client-android-gemini-live-websocket_release"})
    private static interface ClientThreadEvent {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$SendAudioData;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "buf", "", "<init>", "([B)V", "getBuf", "()[B", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class SendAudioData
        implements ClientThreadEvent {
            @NotNull
            private final byte[] buf;

            public SendAudioData(@NotNull byte[] buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                this.buf = buf;
            }

            @NotNull
            public final byte[] getBuf() {
                return this.buf;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$SendUserMessage;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "msg", "Lai/pipecat/client/gemini_live_websocket/AppendedMessage;", "<init>", "(Lai/pipecat/client/gemini_live_websocket/AppendedMessage;)V", "getMsg", "()Lai/pipecat/client/gemini_live_websocket/AppendedMessage;", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class SendUserMessage
        implements ClientThreadEvent {
            @NotNull
            private final AppendedMessage msg;

            public SendUserMessage(@NotNull AppendedMessage msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                this.msg = msg;
            }

            @NotNull
            public final AppendedMessage getMsg() {
                return this.msg;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$SetMicMute;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "muted", "", "<init>", "(Z)V", "getMuted", "()Z", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class SetMicMute
        implements ClientThreadEvent {
            private final boolean muted;

            public SetMicMute(boolean muted) {
                this.muted = muted;
            }

            public final boolean getMuted() {
                return this.muted;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$Stop;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class Stop
        implements ClientThreadEvent {
            @NotNull
            public static final Stop INSTANCE = new Stop();

            private Stop() {
            }

            @NotNull
            public String toString() {
                return "Stop";
            }

            public int hashCode() {
                return 2128874450;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stop)) {
                    return false;
                }
                Stop cfr_ignored_0 = (Stop)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$WebsocketClosed;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class WebsocketClosed
        implements ClientThreadEvent {
            @NotNull
            public static final WebsocketClosed INSTANCE = new WebsocketClosed();

            private WebsocketClosed() {
            }

            @NotNull
            public String toString() {
                return "WebsocketClosed";
            }

            public int hashCode() {
                return -1893977533;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WebsocketClosed)) {
                    return false;
                }
                WebsocketClosed cfr_ignored_0 = (WebsocketClosed)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$WebsocketFailed;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "t", "", "<init>", "(Ljava/lang/Throwable;)V", "getT", "()Ljava/lang/Throwable;", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class WebsocketFailed
        implements ClientThreadEvent {
            @NotNull
            private final Throwable t;

            public WebsocketFailed(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.t = t;
            }

            @NotNull
            public final Throwable getT() {
                return this.t;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent$WebsocketMessage;", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$ClientThreadEvent;", "msg", "Lai/pipecat/client/gemini_live_websocket/IncomingMessage;", "originalText", "", "<init>", "(Lai/pipecat/client/gemini_live_websocket/IncomingMessage;Ljava/lang/String;)V", "getMsg", "()Lai/pipecat/client/gemini_live_websocket/IncomingMessage;", "getOriginalText", "()Ljava/lang/String;", "pipecat-client-android-gemini-live-websocket_release"})
        public static final class WebsocketMessage
        implements ClientThreadEvent {
            @NotNull
            private final IncomingMessage msg;
            @NotNull
            private final String originalText;

            public WebsocketMessage(@NotNull IncomingMessage msg, @NotNull String originalText) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
                this.msg = msg;
                this.originalText = originalText;
            }

            @NotNull
            public final IncomingMessage getMsg() {
                return this.msg;
            }

            @NotNull
            public final String getOriginalText() {
                return this.originalText;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$Companion;", "", "<init>", "()V", "connect", "Lai/pipecat/client/gemini_live_websocket/GeminiClient;", "config", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$Config;", "listener", "Lai/pipecat/client/gemini_live_websocket/GeminiClient$Listener;", "pipecat-client-android-gemini-live-websocket_release"})
    @SourceDebugExtension(value={"SMAP\nGeminiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiClient.kt\nai/pipecat/client/gemini_live_websocket/GeminiClient$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,413:1\n1863#2,2:414\n*S KotlinDebug\n*F\n+ 1 GeminiClient.kt\nai/pipecat/client/gemini_live_websocket/GeminiClient$Companion\n*L\n337#1:414,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresPermission(value="android.permission.RECORD_AUDIO")
        @NotNull
        public final GeminiClient connect(@NotNull Config config, @NotNull Listener listener) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            LinkedBlockingQueue events = new LinkedBlockingQueue();
            AtomicReference<Object> isMicMutedRef = new AtomicReference<Object>(null);
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"GeminiClient", (int)0, () -> Companion.connect$lambda$7(config, listener, isMicMutedRef, events), (int)23, null);
            return new GeminiClient(arg_0 -> Companion.connect$lambda$8(events, arg_0), () -> Companion.connect$lambda$9(events), arg_0 -> Companion.connect$lambda$10(events, arg_0), () -> Companion.connect$lambda$11(isMicMutedRef), null);
        }

        private static final void connect$postEvent(LinkedBlockingQueue<ClientThreadEvent> events, ClientThreadEvent event) {
            events.put(event);
        }

        private static final Unit connect$lambda$7$lambda$0(AtomicReference $audioInCallback, byte[] it) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Function1 function1 = (Function1)$audioInCallback.get();
                if (function1 == null) break block0;
                function1.invoke((Object)it);
            }
            return Unit.INSTANCE;
        }

        private static final Unit connect$lambda$7$lambda$1(Throwable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit connect$lambda$7$lambda$2() {
            return Unit.INSTANCE;
        }

        private static final boolean connect$lambda$7$lambda$3(AudioIn $audioIn) {
            return $audioIn.getMuted();
        }

        private static final void connect$lambda$7$doSendUserMessage(WebSocket ws2, AppendedMessage msg) {
            ws2.send(GeminiClientKt.access$getJSON$p().encodeToString((SerializationStrategy)ClientContentRequest.Companion.serializer(), (Object)new ClientContentRequest(new ClientContentRequest.ClientContent(CollectionsKt.listOf((Object)new ClientContentRequest.ClientContent.Turn(msg.getRole(), CollectionsKt.listOf((Object)new TurnPart(msg.getContent(), null, 2, null)))), true))));
        }

        private static final void connect$lambda$7$stopAudio(AudioIn audioIn, AudioOut audioOut2) {
            audioIn.stop();
            audioOut2.interrupt();
            audioOut2.stop();
        }

        private static final Unit connect$lambda$7$lambda$4(LinkedBlockingQueue $events, byte[] buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$postEvent($events, new ClientThreadEvent.SendAudioData(buf));
            return Unit.INSTANCE;
        }

        private static final Unit connect$lambda$7(Config $config, Listener $listener, AtomicReference $isMicMutedRef, LinkedBlockingQueue $events) {
            OkHttpClient client = new OkHttpClient.Builder().build();
            int inputSampleRate = 16000;
            AtomicReference<Object> audioInCallback = new AtomicReference<Object>(null);
            AudioIn audioIn = new AudioIn(inputSampleRate, (Function1<? super byte[], Unit>)((Function1)arg_0 -> Companion.connect$lambda$7$lambda$0(audioInCallback, arg_0)), (Function1<? super Throwable, Unit>)((Function1)Companion::connect$lambda$7$lambda$1), (Function0<Unit>)((Function0)Companion::connect$lambda$7$lambda$2), $config.getInitialMicEnabled());
            AudioOut audioOut2 = new AudioOut(24000, (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>((Object)$listener){

                public final void invoke(float p0) {
                    ((Listener)this.receiver).onBotAudioLevel(p0);
                }
            }));
            boolean isBotTalking = false;
            $isMicMutedRef.set(() -> Companion.connect$lambda$7$lambda$3(audioIn));
            AtomicReference<Listener> listenerRef = new AtomicReference<Listener>($listener);
            Request request = new Request.Builder().url(HttpUrl.Companion.get("https://generativelanguage.googleapis.com/ws/google.ai.generativelanguage.v1alpha.GenerativeService.BidiGenerateContent").newBuilder().addQueryParameter("key", $config.getApiKey()).build()).build();
            WebSocket ws2 = client.newWebSocket(request, new WebSocketListener($events, $config){
                final /* synthetic */ LinkedBlockingQueue<ClientThreadEvent> $events;
                final /* synthetic */ Config $config;
                {
                    this.$events = $events;
                    this.$config = $config;
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                    Log.i((String)"GeminiClient", (String)("Websocket onClosed(" + code + ", " + reason + ')'));
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.access$connect$postEvent(this.$events, ClientThreadEvent.WebsocketClosed.INSTANCE);
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                    Log.i((String)"GeminiClient", (String)("Websocket onClosing(" + code + ", " + reason + ')'));
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Log.e((String)"GeminiClient", (String)"Websocket onFailure", (Throwable)t);
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.access$connect$postEvent(this.$events, new ClientThreadEvent.WebsocketFailed(t));
                }

                public void onMessage(WebSocket webSocket, String text) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    this.onIncomingMessage(webSocket, text);
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                    this.onIncomingMessage(webSocket, bytes.utf8());
                }

                @SuppressLint(value={"MissingPermission"})
                public final void onIncomingMessage(WebSocket webSocket, String msg) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    Json this_$iv = GeminiClientKt.access$getJSON$p();
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    IncomingMessage data = (IncomingMessage)this_$iv.decodeFromString((DeserializationStrategy)IncomingMessage.Companion.serializer(), msg);
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.access$connect$postEvent(this.$events, new ClientThreadEvent.WebsocketMessage(data, msg));
                }

                public void onOpen(WebSocket webSocket, Response response) {
                    Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Log.i((String)"GeminiClient", (String)"Websocket onOpen");
                    webSocket.send(GeminiClientKt.access$getJSON$p().encodeToString((SerializationStrategy)SetupRequest.Companion.serializer(), (Object)new SetupRequest(this.$config.getModelConfig())));
                }
            });
            while (true) {
                ClientThreadEvent event;
                if ((event = (ClientThreadEvent)$events.take()) instanceof ClientThreadEvent.SendAudioData) {
                    ws2.send(GeminiClientKt.access$getJSON$p().encodeToString((SerializationStrategy)RealtimeInputRequest.Companion.serializer(), (Object)new RealtimeInputRequest(new RealtimeInputRequest.RealtimeInput(CollectionsKt.listOf((Object)InlineData.Companion.ofPcm(inputSampleRate, ((ClientThreadEvent.SendAudioData)event).getBuf()))))));
                    continue;
                }
                if (event instanceof ClientThreadEvent.SendUserMessage) {
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$lambda$7$doSendUserMessage(ws2, ((ClientThreadEvent.SendUserMessage)event).getMsg());
                    continue;
                }
                if (Intrinsics.areEqual((Object)event, (Object)ClientThreadEvent.Stop.INSTANCE)) {
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$lambda$7$stopAudio(audioIn, audioOut2);
                    ws2.close(1000, "user requested close");
                    continue;
                }
                if (Intrinsics.areEqual((Object)event, (Object)ClientThreadEvent.WebsocketClosed.INSTANCE)) {
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$lambda$7$stopAudio(audioIn, audioOut2);
                    Listener listener = (Listener)GeminiClientKt.access$take(listenerRef);
                    if (listener != null) {
                        listener.onSessionEnded("websocket closed", null);
                    }
                    return Unit.INSTANCE;
                }
                if (event instanceof ClientThreadEvent.WebsocketFailed) {
                    ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$lambda$7$stopAudio(audioIn, audioOut2);
                    Listener listener = (Listener)GeminiClientKt.access$take(listenerRef);
                    if (listener != null) {
                        listener.onSessionEnded("websocket failed", ((ClientThreadEvent.WebsocketFailed)event).getT());
                    }
                    return Unit.INSTANCE;
                }
                if (event instanceof ClientThreadEvent.WebsocketMessage) {
                    IncomingMessage data = ((ClientThreadEvent.WebsocketMessage)event).getMsg();
                    if (data.getSetupComplete() != null) {
                        Log.i((String)"GeminiClient", (String)"Setup complete");
                        if ($config.getInitialMessage() != null) {
                            String string = $config.getInitialMessage();
                            ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$lambda$7$doSendUserMessage(ws2, new AppendedMessage("user", string));
                        }
                        Listener listener = listenerRef.get();
                        if (listener != null) {
                            listener.onConnected();
                        }
                        audioInCallback.set(((Function1)arg_0 -> Companion.connect$lambda$7$lambda$4($events, arg_0)));
                        continue;
                    }
                    if (data.getServerContent() != null) {
                        if (data.getServerContent().getModelTurn() != null) {
                            if (!isBotTalking) {
                                isBotTalking = true;
                                Listener listener = listenerRef.get();
                                if (listener != null) {
                                    listener.onBotTalking(true);
                                }
                            }
                            Iterable $this$forEach$iv = data.getServerContent().getModelTurn().getParts();
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                TurnPart part = (TurnPart)element$iv;
                                boolean bl = false;
                                if (part.getText() != null) {
                                    Log.i((String)"GeminiClient", (String)("Model text: " + part.getText()));
                                }
                                if (part.getInlineData() != null) {
                                    InlineData inlineData;
                                    boolean bl2 = false;
                                    byte[] byArray = Base64.decode((String)inlineData.getData(), (int)0);
                                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                                    audioOut2.write(byArray);
                                }
                            }
                        }
                        if (data.getServerContent().getInterrupted()) {
                            Log.i((String)"GeminiClient", (String)"User interrupted model output");
                            audioOut2.interrupt();
                        }
                        if (!data.getServerContent().getTurnComplete()) continue;
                        Log.i((String)"GeminiClient", (String)"Model turn complete");
                        if (!isBotTalking) continue;
                        isBotTalking = false;
                        Listener listener = listenerRef.get();
                        if (listener != null) {
                            listener.onBotTalking(false);
                        }
                        continue;
                    }
                    Log.e((String)"GeminiClient", (String)("Unknown message type: " + ((ClientThreadEvent.WebsocketMessage)event).getOriginalText()));
                    continue;
                }
                if (!(event instanceof ClientThreadEvent.SetMicMute)) break;
                audioIn.setMuted(((ClientThreadEvent.SetMicMute)event).getMuted());
            }
            throw new NoWhenBranchMatchedException();
        }

        private static final Unit connect$lambda$8(LinkedBlockingQueue $events, AppendedMessage text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$postEvent($events, new ClientThreadEvent.SendUserMessage(text));
            return Unit.INSTANCE;
        }

        private static final Unit connect$lambda$9(LinkedBlockingQueue $events) {
            ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$postEvent($events, ClientThreadEvent.Stop.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit connect$lambda$10(LinkedBlockingQueue $events, boolean it) {
            ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$postEvent($events, new ClientThreadEvent.SetMicMute(it));
            return Unit.INSTANCE;
        }

        private static final boolean connect$lambda$11(AtomicReference $isMicMutedRef) {
            Function0 function0 = (Function0)$isMicMutedRef.get();
            return function0 != null ? (Boolean)function0.invoke() : false;
        }

        public static final /* synthetic */ void access$connect$postEvent(LinkedBlockingQueue events, ClientThreadEvent event) {
            ai.pipecat.client.gemini_live_websocket.GeminiClient$Companion.connect$postEvent(events, event);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$Config;", "", "apiKey", "", "modelConfig", "Lai/pipecat/client/types/Value;", "initialMessage", "initialMicEnabled", "", "<init>", "(Ljava/lang/String;Lai/pipecat/client/types/Value;Ljava/lang/String;Z)V", "getApiKey", "()Ljava/lang/String;", "getModelConfig", "()Lai/pipecat/client/types/Value;", "getInitialMessage", "getInitialMicEnabled", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "pipecat-client-android-gemini-live-websocket_release"})
    public static final class Config {
        @NotNull
        private final String apiKey;
        @NotNull
        private final Value modelConfig;
        @Nullable
        private final String initialMessage;
        private final boolean initialMicEnabled;

        public Config(@NotNull String apiKey, @NotNull Value modelConfig, @Nullable String initialMessage, boolean initialMicEnabled) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"modelConfig");
            this.apiKey = apiKey;
            this.modelConfig = modelConfig;
            this.initialMessage = initialMessage;
            this.initialMicEnabled = initialMicEnabled;
        }

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        @NotNull
        public final Value getModelConfig() {
            return this.modelConfig;
        }

        @Nullable
        public final String getInitialMessage() {
            return this.initialMessage;
        }

        public final boolean getInitialMicEnabled() {
            return this.initialMicEnabled;
        }

        @NotNull
        public final String component1() {
            return this.apiKey;
        }

        @NotNull
        public final Value component2() {
            return this.modelConfig;
        }

        @Nullable
        public final String component3() {
            return this.initialMessage;
        }

        public final boolean component4() {
            return this.initialMicEnabled;
        }

        @NotNull
        public final Config copy(@NotNull String apiKey, @NotNull Value modelConfig, @Nullable String initialMessage, boolean initialMicEnabled) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"modelConfig");
            return new Config(apiKey, modelConfig, initialMessage, initialMicEnabled);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, Value value, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = config.apiKey;
            }
            if ((n & 2) != 0) {
                value = config.modelConfig;
            }
            if ((n & 4) != 0) {
                string2 = config.initialMessage;
            }
            if ((n & 8) != 0) {
                bl = config.initialMicEnabled;
            }
            return config.copy(string, value, string2, bl);
        }

        @NotNull
        public String toString() {
            return "Config(apiKey=" + this.apiKey + ", modelConfig=" + this.modelConfig + ", initialMessage=" + this.initialMessage + ", initialMicEnabled=" + this.initialMicEnabled + ')';
        }

        public int hashCode() {
            int result = this.apiKey.hashCode();
            result = result * 31 + this.modelConfig.hashCode();
            result = result * 31 + (this.initialMessage == null ? 0 : this.initialMessage.hashCode());
            result = result * 31 + Boolean.hashCode(this.initialMicEnabled);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual((Object)this.apiKey, (Object)config.apiKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.modelConfig, (Object)config.modelConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.initialMessage, (Object)config.initialMessage)) {
                return false;
            }
            return this.initialMicEnabled == config.initialMicEnabled;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u001a\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiClient$Listener;", "", "onConnected", "", "onSessionEnded", "reason", "", "t", "", "onBotTalking", "isTalking", "", "onBotAudioLevel", "level", "", "pipecat-client-android-gemini-live-websocket_release"})
    public static interface Listener {
        public void onConnected();

        public void onSessionEnded(@NotNull String var1, @Nullable Throwable var2);

        public void onBotTalking(boolean var1);

        public void onBotAudioLevel(float var1);
    }
}

