/*
 * Decompiled with CFR 0.152.
 */
package ai.pipecat.client.gemini_live_websocket;

import ai.pipecat.client.RTVIEventCallbacks;
import ai.pipecat.client.gemini_live_websocket.GeminiClient;
import ai.pipecat.client.gemini_live_websocket.GeminiLiveWebsocketTransport;
import ai.pipecat.client.gemini_live_websocket.GeminiLiveWebsocketTransportKt;
import ai.pipecat.client.result.Future;
import ai.pipecat.client.result.Promise;
import ai.pipecat.client.result.PromiseKt;
import ai.pipecat.client.result.RTVIError;
import ai.pipecat.client.transport.AuthBundle;
import ai.pipecat.client.transport.MsgClientToServer;
import ai.pipecat.client.transport.MsgServerToClient;
import ai.pipecat.client.transport.Transport;
import ai.pipecat.client.transport.TransportContext;
import ai.pipecat.client.transport.TransportFactory;
import ai.pipecat.client.types.MediaDeviceId;
import ai.pipecat.client.types.MediaDeviceInfo;
import ai.pipecat.client.types.Option;
import ai.pipecat.client.types.OptionKt;
import ai.pipecat.client.types.ParticipantTracks;
import ai.pipecat.client.types.ServiceConfig;
import ai.pipecat.client.types.ServiceConfigKt;
import ai.pipecat.client.types.Tracks;
import ai.pipecat.client.types.TransportState;
import ai.pipecat.client.types.Value;
import ai.pipecat.client.utils.ThreadRef;
import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u0003567B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001e\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0017J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001a\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010-\u001a\u00020*H\u0016J\n\u0010.\u001a\u0004\u0018\u00010(H\u0016J\u001c\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010-\u001a\u00020*H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0013H\u0016J\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u00020\u00140\u0012\"\u0004\b\u0000\u00104H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport;", "Lai/pipecat/client/transport/Transport;", "transportContext", "Lai/pipecat/client/transport/TransportContext;", "androidContext", "Landroid/content/Context;", "<init>", "(Lai/pipecat/client/transport/TransportContext;Landroid/content/Context;)V", "state", "Lai/pipecat/client/types/TransportState;", "appContext", "kotlin.jvm.PlatformType", "Landroid/content/Context;", "thread", "Lai/pipecat/client/utils/ThreadRef;", "client", "Lai/pipecat/client/gemini_live_websocket/GeminiClient;", "initDevices", "Lai/pipecat/client/result/Future;", "", "Lai/pipecat/client/result/RTVIError;", "connect", "authBundle", "Lai/pipecat/client/transport/AuthBundle;", "disconnect", "sendMessage", "message", "Lai/pipecat/client/transport/MsgClientToServer;", "setState", "getAllCams", "", "Lai/pipecat/client/types/MediaDeviceInfo;", "getAllMics", "updateMic", "micId", "Lai/pipecat/client/types/MediaDeviceId;", "updateCam", "camId", "selectedMic", "selectedCam", "", "isCamEnabled", "", "isMicEnabled", "enableMic", "enable", "expiry", "enableCam", "tracks", "Lai/pipecat/client/types/Tracks;", "release", "operationNotSupported", "E", "Companion", "AudioDevices", "Factory", "pipecat-client-android-gemini-live-websocket_release"})
@SourceDebugExtension(value={"SMAP\nGeminiLiveWebsocketTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiLiveWebsocketTransport.kt\nai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n309#2:351\n298#2:356\n1557#3:352\n1628#3,3:353\n*S KotlinDebug\n*F\n+ 1 GeminiLiveWebsocketTransport.kt\nai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport\n*L\n232#1:351\n255#1:356\n238#1:352\n238#1:353,3\n*E\n"})
public final class GeminiLiveWebsocketTransport
extends Transport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransportContext transportContext;
    @NotNull
    private TransportState state;
    private final Context appContext;
    @NotNull
    private final ThreadRef thread;
    @Nullable
    private GeminiClient client;
    @NotNull
    private static final String TAG = "DailyTransport";
    @NotNull
    private static final String SERVICE_LLM = "llm";
    @NotNull
    private static final String OPTION_API_KEY = "api_key";
    @NotNull
    private static final String OPTION_INITIAL_USER_MESSAGE = "initial_user_message";
    @NotNull
    private static final String OPTION_MODEL_CONFIG = "model_config";

    public GeminiLiveWebsocketTransport(@NotNull TransportContext transportContext, @NotNull Context androidContext) {
        Intrinsics.checkNotNullParameter((Object)transportContext, (String)"transportContext");
        Intrinsics.checkNotNullParameter((Object)androidContext, (String)"androidContext");
        this.transportContext = transportContext;
        this.state = TransportState.Disconnected;
        this.appContext = androidContext.getApplicationContext();
        this.thread = this.transportContext.getThread();
    }

    @NotNull
    public Future<Unit, RTVIError> initDevices() {
        return PromiseKt.resolvedPromiseOk((ThreadRef)this.thread, (Object)Unit.INSTANCE);
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public Future<Unit, RTVIError> connect(@Nullable AuthBundle authBundle) {
        return this.thread.runOnThreadReturningFuture(() -> GeminiLiveWebsocketTransport.connect$lambda$3(authBundle, this));
    }

    @NotNull
    public Future<Unit, RTVIError> disconnect() {
        return this.thread.runOnThreadReturningFuture(() -> GeminiLiveWebsocketTransport.disconnect$lambda$4(this));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Future<Unit, RTVIError> sendMessage(@NotNull MsgClientToServer message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (Intrinsics.areEqual((Object)message.getType(), (Object)"action")) {
            try {
                void $this$decodeFromJsonElement$iv;
                Json json = GeminiLiveWebsocketTransportKt.access$getJSON$p();
                JsonElement jsonElement = message.getData();
                Intrinsics.checkNotNull((Object)jsonElement);
                JsonElement json$iv = jsonElement;
                boolean $i$f$decodeFromJsonElement = false;
                $this$decodeFromJsonElement$iv.getSerializersModule();
                MsgClientToServer.Data.Action data = (MsgClientToServer.Data.Action)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MsgClientToServer.Data.Action.Companion.serializer(), json$iv);
                if (Intrinsics.areEqual((Object)data.getAction(), (Object)"append_to_messages")) {
                    void value$iv;
                    void $this$encodeToJsonElement$iv;
                    void $this$mapTo$iv$iv;
                    Value value = OptionKt.getValueFor((List)data.getArguments(), (String)"messages");
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type ai.pipecat.client.types.Value.Array");
                    Object $this$map$iv = ((Value.Array)value).unbox-impl();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Value value2 = (Value)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type ai.pipecat.client.types.Value.Object");
                        collection.add(Value.Object.box-impl((Map)((Value.Object)it).unbox-impl()));
                    }
                    List messages = (List)destination$iv$iv;
                    $this$map$iv = messages.iterator();
                    while ($this$map$iv.hasNext()) {
                        Map appendedMessage = ((Value.Object)$this$map$iv.next()).unbox-impl();
                        Object v = appendedMessage.get("role");
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type ai.pipecat.client.types.Value.Str");
                        String role = ((Value.Str)v).unbox-impl();
                        Object v2 = appendedMessage.get("content");
                        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type ai.pipecat.client.types.Value.Str");
                        String content = ((Value.Str)v2).unbox-impl();
                        Log.i((String)TAG, (String)("Sending message as " + role + ": '" + content + '\''));
                        GeminiClient geminiClient = this.client;
                        if (geminiClient == null) continue;
                        geminiClient.sendUserMessage(role, content);
                    }
                    String string = message.getId();
                    String string2 = message.getLabel();
                    $this$map$iv = GeminiLiveWebsocketTransportKt.access$getJSON$p();
                    MsgServerToClient.Data.ActionResponse appendedMessage = new MsgServerToClient.Data.ActionResponse((Value)Value.Null.INSTANCE);
                    boolean $i$f$encodeToJsonElement = false;
                    $this$encodeToJsonElement$iv.getSerializersModule();
                    this.transportContext.onMessage(new MsgServerToClient(string, string2, "action-response", $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)MsgServerToClient.Data.ActionResponse.Companion.serializer(), (Object)value$iv)));
                    return PromiseKt.resolvedPromiseOk((ThreadRef)this.thread, (Object)Unit.INSTANCE);
                }
                return this.operationNotSupported();
            }
            catch (Exception e) {
                return PromiseKt.resolvedPromiseErr((ThreadRef)this.thread, (Object)new RTVIError.ExceptionThrown(e));
            }
        }
        return this.operationNotSupported();
    }

    @NotNull
    public TransportState state() {
        return this.state;
    }

    public void setState(@NotNull TransportState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Log.i((String)TAG, (String)("setState(" + state + ')'));
        this.thread.assertCurrent();
        this.state = state;
        this.transportContext.getCallbacks().onTransportStateChanged(state);
    }

    @NotNull
    public Future<List<MediaDeviceInfo>, RTVIError> getAllCams() {
        return PromiseKt.resolvedPromiseOk((ThreadRef)this.thread, (Object)CollectionsKt.emptyList());
    }

    @NotNull
    public Future<List<MediaDeviceInfo>, RTVIError> getAllMics() {
        Object[] objectArray = new MediaDeviceInfo[]{AudioDevices.INSTANCE.getEarpiece(), AudioDevices.INSTANCE.getSpeakerphone()};
        return PromiseKt.resolvedPromiseOk((ThreadRef)this.thread, (Object)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public Future<Unit, RTVIError> updateMic(@NotNull MediaDeviceId micId) {
        Intrinsics.checkNotNullParameter((Object)micId, (String)"micId");
        Object object = this.appContext.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        AudioManager audioManager = (AudioManager)object;
        audioManager.setSpeakerphoneOn(Intrinsics.areEqual((Object)micId, (Object)AudioDevices.INSTANCE.getSpeakerphone().getId()));
        return PromiseKt.resolvedPromiseOk((ThreadRef)this.thread, (Object)Unit.INSTANCE);
    }

    @NotNull
    public Future<Unit, RTVIError> updateCam(@NotNull MediaDeviceId camId) {
        Intrinsics.checkNotNullParameter((Object)camId, (String)"camId");
        return this.operationNotSupported();
    }

    @NotNull
    public MediaDeviceInfo selectedMic() {
        MediaDeviceInfo mediaDeviceInfo;
        Object object = this.appContext.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        AudioManager audioManager = (AudioManager)object;
        boolean bl = audioManager.isSpeakerphoneOn();
        if (bl) {
            mediaDeviceInfo = AudioDevices.INSTANCE.getSpeakerphone();
        } else if (!bl) {
            mediaDeviceInfo = AudioDevices.INSTANCE.getEarpiece();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mediaDeviceInfo;
    }

    @Nullable
    public Void selectedCam() {
        return null;
    }

    public boolean isCamEnabled() {
        return false;
    }

    public boolean isMicEnabled() {
        GeminiClient geminiClient = this.client;
        return geminiClient != null ? !geminiClient.getMicMuted() : false;
    }

    @NotNull
    public Future<Unit, RTVIError> enableMic(boolean enable) {
        GeminiClient geminiClient = this.client;
        if (geminiClient != null) {
            geminiClient.setMicMuted(!enable);
        }
        this.thread.runOnThread(() -> GeminiLiveWebsocketTransport.enableMic$lambda$6(this, enable));
        return PromiseKt.resolvedPromiseOk((ThreadRef)this.thread, (Object)Unit.INSTANCE);
    }

    @Nullable
    public Void expiry() {
        return null;
    }

    @NotNull
    public Future<Unit, RTVIError> enableCam(boolean enable) {
        return this.operationNotSupported();
    }

    @NotNull
    public Tracks tracks() {
        return new Tracks(new ParticipantTracks(null, null), null);
    }

    public void release() {
        this.thread.assertCurrent();
        GeminiClient geminiClient = this.client;
        if (geminiClient != null) {
            geminiClient.close();
        }
        this.client = null;
    }

    private final <E> Future<E, RTVIError> operationNotSupported() {
        return PromiseKt.resolvedPromiseErr((ThreadRef)this.thread, (Object)new RTVIError.OtherError("Operation not supported"));
    }

    private static final void connect$lambda$3$lambda$0(GeminiLiveWebsocketTransport this$0, RTVIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setState(TransportState.Error);
    }

    private static final Unit connect$lambda$3$lambda$2$lambda$1(GeminiLiveWebsocketTransport this$0, String $apiKey, Value $modelConfig, String $initialUserMessage, Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        this$0.client = GeminiClient.Companion.connect(new GeminiClient.Config($apiKey, $modelConfig, $initialUserMessage, this$0.transportContext.getOptions().getEnableMic()), new GeminiClient.Listener(this$0, (Promise<Unit, RTVIError>)promise){
            final /* synthetic */ GeminiLiveWebsocketTransport this$0;
            final /* synthetic */ Promise<Unit, RTVIError> $promise;
            {
                this.this$0 = $receiver;
                this.$promise = $promise;
            }

            public void onConnected() {
                GeminiLiveWebsocketTransport.access$getThread$p(this.this$0).runOnThread(() -> connect.1.2.1.1.onConnected$lambda$0(this.this$0, this.$promise));
            }

            public void onSessionEnded(String reason, Throwable t) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                GeminiLiveWebsocketTransport.access$getThread$p(this.this$0).runOnThread(() -> connect.1.2.1.1.onSessionEnded$lambda$2(reason, t, this.this$0, this.$promise));
            }

            public void onBotTalking(boolean isTalking) {
                GeminiLiveWebsocketTransport.access$getThread$p(this.this$0).runOnThread(() -> connect.1.2.1.1.onBotTalking$lambda$4(this.this$0, isTalking));
            }

            public void onBotAudioLevel(float level) {
                GeminiLiveWebsocketTransport.access$getThread$p(this.this$0).runOnThread(() -> connect.1.2.1.1.onBotAudioLevel$lambda$5(this.this$0, level));
            }

            private static final void onConnected$lambda$0(GeminiLiveWebsocketTransport this$0, Promise $promise) {
                RTVIEventCallbacks cb = GeminiLiveWebsocketTransport.access$getTransportContext$p(this$0).getCallbacks();
                this$0.setState(TransportState.Connected);
                cb.onConnected();
                cb.onParticipantJoined(GeminiLiveWebsocketTransportKt.access$getLOCAL_PARTICIPANT$p());
                cb.onParticipantJoined(GeminiLiveWebsocketTransportKt.access$getBOT_PARTICIPANT$p());
                this$0.setState(TransportState.Ready);
                cb.onBotReady("local", CollectionsKt.emptyList());
                $promise.resolveOk((Object)Unit.INSTANCE);
            }

            private static final void onSessionEnded$lambda$2(String $reason, Throwable $t, GeminiLiveWebsocketTransport this$0, Promise $promise) {
                block0: {
                    Log.i((String)"DailyTransport", (String)("onSessionEnded: " + $reason), (Throwable)$t);
                    this$0.setState(TransportState.Disconnected);
                    GeminiLiveWebsocketTransport.access$getTransportContext$p(this$0).getCallbacks().onDisconnected();
                    $promise.resolveErr((Object)new RTVIError.OtherError("Session disconnected: " + $reason));
                    Throwable throwable = $t;
                    if (throwable == null) break block0;
                    Throwable it = throwable;
                    boolean bl = false;
                    Log.e((String)"DailyTransport", (String)"Session ended with exception", (Throwable)it);
                }
            }

            private static final void onBotTalking$lambda$4(GeminiLiveWebsocketTransport this$0, boolean $isTalking) {
                RTVIEventCallbacks rTVIEventCallbacks;
                RTVIEventCallbacks $this$onBotTalking_u24lambda_u244_u24lambda_u243 = rTVIEventCallbacks = GeminiLiveWebsocketTransport.access$getTransportContext$p(this$0).getCallbacks();
                boolean bl = false;
                if ($isTalking) {
                    $this$onBotTalking_u24lambda_u244_u24lambda_u243.onBotStartedSpeaking();
                } else {
                    $this$onBotTalking_u24lambda_u244_u24lambda_u243.onBotStoppedSpeaking();
                }
            }

            private static final void onBotAudioLevel$lambda$5(GeminiLiveWebsocketTransport this$0, float $level) {
                GeminiLiveWebsocketTransport.access$getTransportContext$p(this$0).getCallbacks().onRemoteAudioLevel($level, GeminiLiveWebsocketTransportKt.access$getBOT_PARTICIPANT$p());
            }
        });
        return Unit.INSTANCE;
    }

    private static final Future connect$lambda$3$lambda$2(GeminiLiveWebsocketTransport this$0, Unit unit) {
        String initialUserMessage;
        List options;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        List list = options = ServiceConfigKt.getOptionsFor((List)this$0.transportContext.getOptions().getParams().getConfig(), (String)SERVICE_LLM);
        Value value = list != null ? OptionKt.getValueFor((List)list, (String)OPTION_API_KEY) : null;
        String string = value instanceof Value.Str ? ((Value.Str)value).unbox-impl() : null;
        if (string == null) {
            string = null;
        }
        String apiKey = string;
        List list2 = options;
        Value modelConfig = list2 != null ? OptionKt.getValueFor((List)list2, (String)OPTION_MODEL_CONFIG) : null;
        List list3 = options;
        Object object = list3 != null ? OptionKt.getValueFor((List)list3, (String)OPTION_INITIAL_USER_MESSAGE) : null;
        String string2 = object instanceof Value.Str ? ((Value.Str)object).unbox-impl() : null;
        if (string2 == null) {
            string2 = initialUserMessage = null;
        }
        if (apiKey == null) {
            return PromiseKt.resolvedPromiseErr((ThreadRef)this$0.thread, (Object)new RTVIError.OtherError("Ensure api_key is set in llm service options"));
        }
        if (modelConfig == null) {
            return PromiseKt.resolvedPromiseErr((ThreadRef)this$0.thread, (Object)new RTVIError.OtherError("Ensure model_config is set in llm service options"));
        }
        return PromiseKt.withPromise((ThreadRef)this$0.thread, arg_0 -> GeminiLiveWebsocketTransport.connect$lambda$3$lambda$2$lambda$1(this$0, apiKey, modelConfig, initialUserMessage, arg_0));
    }

    private static final Future connect$lambda$3(AuthBundle $authBundle, GeminiLiveWebsocketTransport this$0) {
        Log.i((String)TAG, (String)("connect(" + $authBundle + ')'));
        if (this$0.client != null) {
            return PromiseKt.resolvedPromiseErr((ThreadRef)this$0.thread, (Object)new RTVIError.OtherError("Connection already active"));
        }
        this$0.transportContext.getCallbacks().onInputsUpdated(false, this$0.transportContext.getOptions().getEnableMic());
        this$0.setState(TransportState.Connecting);
        return this$0.initDevices().withErrorCallback(arg_0 -> GeminiLiveWebsocketTransport.connect$lambda$3$lambda$0(this$0, arg_0)).chain(arg_0 -> GeminiLiveWebsocketTransport.connect$lambda$3$lambda$2(this$0, arg_0));
    }

    private static final Future disconnect$lambda$4(GeminiLiveWebsocketTransport this$0) {
        block0: {
            GeminiClient geminiClient = this$0.client;
            if (geminiClient == null) break block0;
            geminiClient.close();
        }
        return PromiseKt.resolvedPromiseOk((ThreadRef)this$0.thread, (Object)Unit.INSTANCE);
    }

    private static final void enableMic$lambda$6(GeminiLiveWebsocketTransport this$0, boolean $enable) {
        this$0.transportContext.getCallbacks().onInputsUpdated(false, $enable);
    }

    public static final /* synthetic */ ThreadRef access$getThread$p(GeminiLiveWebsocketTransport $this) {
        return $this.thread;
    }

    public static final /* synthetic */ TransportContext access$getTransportContext$p(GeminiLiveWebsocketTransport $this) {
        return $this.transportContext;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport$AudioDevices;", "", "<init>", "()V", "Speakerphone", "Lai/pipecat/client/types/MediaDeviceInfo;", "getSpeakerphone", "()Lai/pipecat/client/types/MediaDeviceInfo;", "Earpiece", "getEarpiece", "pipecat-client-android-gemini-live-websocket_release"})
    public static final class AudioDevices {
        @NotNull
        public static final AudioDevices INSTANCE = new AudioDevices();
        @NotNull
        private static final MediaDeviceInfo Speakerphone = new MediaDeviceInfo(new MediaDeviceId("speakerphone"), "Speakerphone");
        @NotNull
        private static final MediaDeviceInfo Earpiece = new MediaDeviceInfo(new MediaDeviceId("earpiece"), "Earpiece");

        private AudioDevices() {
        }

        @NotNull
        public final MediaDeviceInfo getSpeakerphone() {
            return Speakerphone;
        }

        @NotNull
        public final MediaDeviceInfo getEarpiece() {
            return Earpiece;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JQ\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport$Companion;", "", "<init>", "()V", "TAG", "", "SERVICE_LLM", "OPTION_API_KEY", "OPTION_INITIAL_USER_MESSAGE", "OPTION_MODEL_CONFIG", "buildConfig", "", "Lai/pipecat/client/types/ServiceConfig;", "apiKey", "model", "initialUserMessage", "generationConfig", "Lai/pipecat/client/types/Value$Object;", "systemInstruction", "Lai/pipecat/client/types/Value;", "tools", "Lai/pipecat/client/types/Value$Array;", "buildConfig-8q-nd90", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lai/pipecat/client/types/Value;Ljava/util/List;)Ljava/util/List;", "pipecat-client-android-gemini-live-websocket_release"})
    @SourceDebugExtension(value={"SMAP\nGeminiLiveWebsocketTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiLiveWebsocketTransport.kt\nai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ServiceConfig> buildConfig-8q-nd90(@NotNull String apiKey, @NotNull String model, @Nullable String initialUserMessage, @NotNull Map<String, ? extends Value> generationConfig, @Nullable Value systemInstruction, @NotNull List<? extends Value> tools) {
            Value value;
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter(generationConfig, (String)"generationConfig");
            Intrinsics.checkNotNullParameter(tools, (String)"tools");
            String string = GeminiLiveWebsocketTransport.SERVICE_LLM;
            Object[] objectArray = new Option[3];
            objectArray[0] = new Option(GeminiLiveWebsocketTransport.OPTION_API_KEY, apiKey);
            Object[] objectArray2 = objectArray;
            int n = 1;
            String string2 = GeminiLiveWebsocketTransport.OPTION_INITIAL_USER_MESSAGE;
            String string3 = initialUserMessage;
            if (string3 != null) {
                void it;
                String string4 = string3;
                String string5 = string2;
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                String string6 = string;
                boolean bl = false;
                String string7 = Value.Str.constructor-impl((String)it);
                string = string6;
                objectArray2 = objectArray3;
                n = n2;
                string2 = string5;
                value = Value.Str.box-impl((String)string7);
            } else {
                value = (Value)Value.Null.INSTANCE;
            }
            Value value2 = value;
            String string8 = string2;
            objectArray2[n] = new Option(string8, value2);
            Pair[] pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"model", (Object)Value.Str.box-impl((String)Value.Str.constructor-impl((String)model)));
            pairArray[1] = TuplesKt.to((Object)"generation_config", (Object)Value.Object.box-impl(generationConfig));
            Value value3 = systemInstruction;
            if (value3 == null) {
                value3 = (Value)Value.Null.INSTANCE;
            }
            pairArray[2] = TuplesKt.to((Object)"system_instruction", (Object)value3);
            pairArray[3] = TuplesKt.to((Object)"tools", (Object)Value.Array.box-impl(tools));
            objectArray[2] = new Option(GeminiLiveWebsocketTransport.OPTION_MODEL_CONFIG, (Value)Value.Object.box-impl((Map)Value.Object.constructor-impl((Pair[])pairArray)));
            List list = CollectionsKt.listOf((Object[])objectArray);
            String string9 = string;
            return CollectionsKt.listOf((Object)new ServiceConfig(string9, list));
        }

        public static /* synthetic */ List buildConfig-8q-nd90$default(Companion companion, String string, String string2, String string3, Map map, Value value, List list, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "models/gemini-2.0-flash-exp";
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                map = Value.Object.constructor-impl((Pair[])new Pair[0]);
            }
            if ((n & 0x10) != 0) {
                value = null;
            }
            if ((n & 0x20) != 0) {
                list = Value.Array.constructor-impl((Value[])new Value[0]);
            }
            return companion.buildConfig-8q-nd90(string, string2, string3, map, value, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lai/pipecat/client/gemini_live_websocket/GeminiLiveWebsocketTransport$Factory;", "Lai/pipecat/client/transport/TransportFactory;", "androidContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "createTransport", "Lai/pipecat/client/transport/Transport;", "context", "Lai/pipecat/client/transport/TransportContext;", "pipecat-client-android-gemini-live-websocket_release"})
    public static final class Factory
    implements TransportFactory {
        @NotNull
        private final Context androidContext;

        public Factory(@NotNull Context androidContext) {
            Intrinsics.checkNotNullParameter((Object)androidContext, (String)"androidContext");
            this.androidContext = androidContext;
        }

        @NotNull
        public Transport createTransport(@NotNull TransportContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new GeminiLiveWebsocketTransport(context, this.androidContext);
        }
    }
}

