/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.quarkus.devservices.deployment;

import ai.pipestream.quarkus.devservices.PipelineDevServicesConfig;
import ai.pipestream.quarkus.devservices.runtime.ComposeDevServicesConfigBuilder;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.Logger;

class PipelineDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(PipelineDevServicesProcessor.class);
    private static final String FEATURE = "pipeline-devservices";
    private static final String COMPOSE_FILE_RESOURCE = "compose-devservices.yml";
    private static final String INIT_SCRIPT_RESOURCE = "init-mysql.sql";
    private static final String VERSION_FILE = ".version";
    private static final String COMPOSE_CONFIG_PREFIX = "quarkus.compose.devservices.";
    private static final String PIPELINE_CONFIG_PREFIX = "pipeline.devservices.";
    private static final boolean DEFAULT_START_SERVICES = true;
    private static final boolean DEFAULT_STOP_SERVICES = false;
    private static final boolean DEFAULT_REUSE_PROJECT_FOR_TESTS = true;

    PipelineDevServicesProcessor() {
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    FeatureBuildItem feature() {
        LOG.info((Object)"========================================");
        LOG.info((Object)"Pipeline Dev Services extension - feature build step executing");
        LOG.info((Object)"========================================");
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    StaticInitConfigBuilderBuildItem registerConfigBuilder() {
        return new StaticInitConfigBuilderBuildItem(ComposeDevServicesConfigBuilder.class);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevServicesResultBuildItem setupComposeFile(PipelineDevServicesConfig config) {
        LOG.info((Object)"========================================");
        LOG.info((Object)"Pipeline Dev Services extension - setupComposeFile build step executing");
        LOG.info((Object)("Extension enabled: " + config.enabled()));
        LOG.info((Object)"========================================");
        if (!config.enabled()) {
            LOG.warn((Object)"Pipeline Dev Services extension is disabled");
            this.clearPipelineSystemProperties();
            Map<String, String> disabledConfig = Map.of("quarkus.compose.devservices.enabled", Boolean.FALSE.toString());
            return DevServicesResultBuildItem.discovered().name(FEATURE).description("Pipeline Dev Services disabled").config(disabledConfig).build();
        }
        try {
            InputStream composeResource;
            String targetDir = config.targetDir();
            Path targetPath = Paths.get(targetDir, new String[0]);
            Path composeFile = targetPath.resolve(COMPOSE_FILE_RESOURCE);
            Path versionFile = targetPath.resolve(VERSION_FILE);
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectories(targetPath, new FileAttribute[0]);
                LOG.info((Object)("Created target directory: " + String.valueOf(targetPath)));
            }
            if ((composeResource = Thread.currentThread().getContextClassLoader().getResourceAsStream(COMPOSE_FILE_RESOURCE)) == null) {
                LOG.warn((Object)"Compose file not found in classpath: compose-devservices.yml");
                this.clearPipelineSystemProperties();
                return DevServicesResultBuildItem.discovered().name(FEATURE).description("Pipeline Dev Services compose resource not found").config(Map.of()).build();
            }
            byte[] resourceBytes = composeResource.readAllBytes();
            String resourceSha = this.calculateSHA(resourceBytes);
            composeResource.close();
            if (Files.exists(composeFile, new LinkOption[0])) {
                VersionInfo existingVersion = this.readVersionInfo(versionFile);
                if (existingVersion != null && existingVersion.sha().equals(resourceSha)) {
                    LOG.debug((Object)"Compose file is up to date");
                } else if (existingVersion != null && !existingVersion.sha().equals(resourceSha)) {
                    if (config.forceUpdate()) {
                        LOG.info((Object)"Force update enabled, updating compose file");
                        this.updateComposeFile(composeFile, versionFile, resourceBytes, resourceSha, config);
                    } else if (config.autoUpdate()) {
                        byte[] existingBytes = Files.readAllBytes(composeFile);
                        String existingSha = this.calculateSHA(existingBytes);
                        if (existingVersion.sha().equals(existingSha)) {
                            LOG.info((Object)"Auto-updating compose file (version changed)");
                            this.updateComposeFile(composeFile, versionFile, resourceBytes, resourceSha, config);
                        } else {
                            LOG.warn((Object)"Compose file was manually edited. Skipping auto-update. Set quarkus.pipeline-devservices.force-update=true to force update.");
                        }
                    } else {
                        LOG.debug((Object)"Auto-update disabled, using existing compose file");
                    }
                } else {
                    LOG.info((Object)"Extracting compose file (first time)");
                    this.extractComposeFile(composeFile, versionFile, resourceBytes, resourceSha);
                }
            } else {
                LOG.info((Object)("Extracting compose file to: " + String.valueOf(composeFile)));
                this.extractComposeFile(composeFile, versionFile, resourceBytes, resourceSha);
            }
            this.validateYaml(composeFile);
            Path initScriptFile = targetPath.resolve(INIT_SCRIPT_RESOURCE);
            try (InputStream initScriptResource = Thread.currentThread().getContextClassLoader().getResourceAsStream(INIT_SCRIPT_RESOURCE);){
                if (initScriptResource != null) {
                    LOG.debug((Object)("Extracting init script to: " + String.valueOf(initScriptFile)));
                    byte[] initScriptBytes = initScriptResource.readAllBytes();
                    Files.write(initScriptFile, initScriptBytes, new OpenOption[0]);
                } else {
                    LOG.debug((Object)"Init script not found in classpath: init-mysql.sql");
                }
            }
            String composeFileAbsolutePath = composeFile.toAbsolutePath().toString();
            String projectName = config.projectName().filter(s -> !s.isEmpty()).orElse("pipeline-shared-devservices");
            LOG.info((Object)("Pipeline Dev Services configured: " + composeFileAbsolutePath));
            LOG.info((Object)"To enable Compose Dev Services, add the following properties to your application.properties:");
            LOG.info((Object)"  %dev.quarkus.compose.devservices.enabled=true");
            LOG.info((Object)("  %dev.quarkus.compose.devservices.files=" + composeFileAbsolutePath));
            LOG.info((Object)("  %dev.quarkus.compose.devservices.project-name=" + projectName));
            LOG.info((Object)"  %dev.quarkus.compose.devservices.start-services=true");
            LOG.info((Object)"  %dev.quarkus.compose.devservices.stop-services=false");
            LOG.info((Object)"  %dev.quarkus.compose.devservices.reuse-project-for-tests=true");
            LinkedHashMap<String, String> composeConfig = new LinkedHashMap<String, String>();
            composeConfig.put("quarkus.compose.devservices.enabled", Boolean.toString(true));
            composeConfig.put("quarkus.compose.devservices.files", composeFileAbsolutePath);
            composeConfig.put("quarkus.compose.devservices.project-name", projectName);
            composeConfig.put("quarkus.compose.devservices.start-services", Boolean.toString(true));
            composeConfig.put("quarkus.compose.devservices.stop-services", Boolean.toString(false));
            composeConfig.put("quarkus.compose.devservices.reuse-project-for-tests", Boolean.toString(true));
            this.applyPipelineSystemProperties(composeConfig);
            this.updateComposeConfigBuilder(composeFileAbsolutePath, projectName);
            return DevServicesResultBuildItem.discovered().name(FEATURE).description("Pipeline Dev Services compose provisioning").config(composeConfig).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to setup compose file", (Throwable)e);
            throw new RuntimeException("Failed to setup Pipeline Dev Services compose file", e);
        }
    }

    private void extractComposeFile(Path composeFile, Path versionFile, byte[] resourceBytes, String resourceSha) throws IOException {
        Files.write(composeFile, resourceBytes, new OpenOption[0]);
        this.writeVersionInfo(versionFile, resourceSha);
        LOG.info((Object)"Compose file extracted and version info written");
    }

    private void updateComposeFile(Path composeFile, Path versionFile, byte[] resourceBytes, String resourceSha, PipelineDevServicesConfig config) throws IOException {
        VersionInfo existingVersion = this.readVersionInfo(versionFile);
        if (existingVersion != null && Files.exists(composeFile, new LinkOption[0])) {
            byte[] existingBytes = Files.readAllBytes(composeFile);
            String existingSha = this.calculateSHA(existingBytes);
            if (!existingVersion.sha().equals(existingSha)) {
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
                Path backupFile = Paths.get(composeFile.toString() + ".backup." + timestamp, new String[0]);
                Files.copy(composeFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
                LOG.info((Object)("Created backup of edited compose file: " + String.valueOf(backupFile)));
            }
        }
        Files.write(composeFile, resourceBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.writeVersionInfo(versionFile, resourceSha);
        LOG.info((Object)"Compose file updated");
    }

    private void validateYaml(Path composeFile) {
        try {
            if (!Files.exists(composeFile, new LinkOption[0]) || Files.size(composeFile) == 0L) {
                throw new RuntimeException("Compose file is empty or doesn't exist");
            }
            String content = Files.readString(composeFile);
            if (!(content.contains("services:") || content.contains("version:") || content.contains("name:"))) {
                LOG.warn((Object)"Compose file may not be valid YAML - missing expected markers");
            }
            LOG.debug((Object)"YAML validation passed");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to validate compose file", e);
        }
    }

    private String calculateSHA(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate SHA", e);
        }
    }

    private void writeVersionInfo(Path versionFile, String sha) throws IOException {
        String content = "sha=" + sha + "\n";
        Files.write(versionFile, content.getBytes(), new OpenOption[0]);
    }

    private VersionInfo readVersionInfo(Path versionFile) {
        try {
            if (!Files.exists(versionFile, new LinkOption[0])) {
                return null;
            }
            String content = Files.readString(versionFile);
            String sha = null;
            for (String line : content.split("\n")) {
                if (!line.startsWith("sha=")) continue;
                sha = line.substring(4).trim();
                break;
            }
            return sha != null ? new VersionInfo(sha) : null;
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to read version info", (Throwable)e);
            return null;
        }
    }

    private void applyPipelineSystemProperties(Map<String, String> composeConfig) {
        composeConfig.forEach((key, value) -> {
            if (key.startsWith(COMPOSE_CONFIG_PREFIX)) {
                String pipelineKey = PIPELINE_CONFIG_PREFIX + key.substring(COMPOSE_CONFIG_PREFIX.length());
                System.setProperty(pipelineKey, value);
            }
        });
    }

    private void clearPipelineSystemProperties() {
        String[] keys;
        for (String key : keys = new String[]{"pipeline.devservices.enabled", "pipeline.devservices.files", "pipeline.devservices.project-name", "pipeline.devservices.start-services", "pipeline.devservices.stop-services", "pipeline.devservices.reuse-project-for-tests"}) {
            System.clearProperty(key);
        }
        ComposeDevServicesConfigBuilder.composeFiles = null;
        ComposeDevServicesConfigBuilder.projectName = null;
        ComposeDevServicesConfigBuilder.enabled = false;
        ComposeDevServicesConfigBuilder.startServices = true;
        ComposeDevServicesConfigBuilder.stopServices = false;
        ComposeDevServicesConfigBuilder.reuseProjectForTests = true;
    }

    private void updateComposeConfigBuilder(String composeFileAbsolutePath, String projectName) {
        ComposeDevServicesConfigBuilder.composeFiles = composeFileAbsolutePath;
        ComposeDevServicesConfigBuilder.projectName = projectName;
        ComposeDevServicesConfigBuilder.enabled = true;
        ComposeDevServicesConfigBuilder.startServices = true;
        ComposeDevServicesConfigBuilder.stopServices = false;
        ComposeDevServicesConfigBuilder.reuseProjectForTests = true;
    }

    private record VersionInfo(String sha) {
    }
}

