/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.registration.clients;

import ai.pipestream.dynamic.grpc.client.DynamicGrpcClientFactory;
import ai.pipestream.platform.registration.EventType;
import ai.pipestream.platform.registration.ModuleRegistrationRequest;
import ai.pipestream.platform.registration.RegistrationEvent;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.Multi;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
@IfBuildProperty(name="module.registration.enabled", stringValue="true")
public class ModuleRegistrationClient {
    private static final Logger LOG = Logger.getLogger(ModuleRegistrationClient.class);
    @Inject
    DynamicGrpcClientFactory grpcClientFactory;
    @ConfigProperty(name="module.registration.module-name")
    String moduleName;
    @ConfigProperty(name="module.registration.host", defaultValue="localhost")
    String host;
    @ConfigProperty(name="module.registration.port")
    int port;
    @ConfigProperty(name="quarkus.application.version", defaultValue="1.0.0")
    String version;
    @ConfigProperty(name="quarkus.profile")
    String profile;
    private static final String REGISTRATION_SERVICE = "platform-registration-service";

    void onStart(@Observes StartupEvent ev) {
        LOG.infof("Auto-registering module %s with platform registration service", (Object)this.moduleName);
        this.registerModule().subscribe().with(event -> {
            LOG.infof("Module registration event: %s - %s", (Object)event.getEventType(), (Object)event.getMessage());
            if (event.getEventType() == EventType.COMPLETED) {
                LOG.infof("Successfully registered module %s with platform", (Object)this.moduleName);
            } else if (event.getEventType() == EventType.FAILED) {
                LOG.errorf("Failed to register module %s: %s", (Object)this.moduleName, (Object)event.getMessage());
                if (event.hasErrorDetail()) {
                    LOG.error((Object)("Details: " + event.getErrorDetail()));
                }
            }
        }, throwable -> LOG.error((Object)"Module registration failed", throwable), () -> LOG.debug((Object)"Module registration stream completed"));
    }

    public Multi<RegistrationEvent> registerModule() {
        return this.grpcClientFactory.getPlatformRegistrationClient(REGISTRATION_SERVICE).onItem().transformToMulti(stub -> {
            ModuleRegistrationRequest request = this.buildRequest();
            LOG.infof("Registering module: %s at %s:%d", (Object)this.moduleName, (Object)this.determineHost(), (Object)this.port);
            return stub.registerModule(request);
        }).onFailure().recoverWithMulti(throwable -> {
            LOG.error((Object)"Failed to connect to registration service", throwable);
            return Multi.createFrom().item((Object)RegistrationEvent.newBuilder().setEventType(EventType.FAILED).setMessage("Failed to connect to registration service").setErrorDetail(throwable.getMessage()).build());
        });
    }

    private ModuleRegistrationRequest buildRequest() {
        return ModuleRegistrationRequest.newBuilder().setModuleName(this.moduleName).setHost(this.determineHost()).setPort(this.port).setVersion(this.version).build();
    }

    private String determineHost() {
        if ("dev".equals(this.profile) && "localhost".equals(this.host)) {
            String bridge = System.getenv("DOCKER_BRIDGE_IP");
            return bridge != null && !bridge.isEmpty() ? bridge : "172.17.0.1";
        }
        return this.host;
    }
}

