/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.registration.clients;

import ai.pipestream.common.grpc.GrpcClientFactory;
import ai.pipestream.data.module.ServiceRegistrationMetadata;
import ai.pipestream.platform.registration.EventType;
import ai.pipestream.platform.registration.ModuleRegistrationRequest;
import ai.pipestream.platform.registration.RegistrationEvent;
import ai.pipestream.platform.registration.ServiceRegistrationRequest;
import ai.pipestream.platform.registration.UnregisterRequest;
import ai.pipestream.platform.registration.UnregisterResponse;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
@IfBuildProperty(name="service.registration.enabled", stringValue="true")
public class PlatformRegistrationClient {
    private static final Logger LOG = Logger.getLogger(PlatformRegistrationClient.class);
    @Inject
    GrpcClientFactory grpcClientFactory;
    @ConfigProperty(name="service.registration.enabled", defaultValue="false")
    boolean registrationEnabled;
    @ConfigProperty(name="service.registration.service-name", defaultValue="")
    String serviceName;
    @ConfigProperty(name="service.registration.description", defaultValue="")
    String description;
    @ConfigProperty(name="service.registration.service-type", defaultValue="APPLICATION")
    String serviceType;
    @ConfigProperty(name="service.registration.host", defaultValue="localhost")
    String serviceHost;
    @ConfigProperty(name="service.registration.port", defaultValue="0")
    int servicePort;
    @ConfigProperty(name="service.registration.capabilities", defaultValue="")
    String capabilities;
    @ConfigProperty(name="service.registration.tags", defaultValue="")
    String tags;
    @ConfigProperty(name="quarkus.application.version", defaultValue="1.0.0")
    String version;
    @ConfigProperty(name="quarkus.profile")
    String profile;
    private static final String REGISTRATION_SERVICE = "platform-registration-service";

    void onStart(@Observes StartupEvent ev) {
        if (!this.registrationEnabled) {
            LOG.info((Object)"Service registration disabled");
            return;
        }
        LOG.infof("Auto-registering %s with platform registration service", (Object)this.serviceName);
        this.registerService().subscribe().with(event -> {
            LOG.infof("Registration event: %s - %s", (Object)event.getEventType(), (Object)event.getMessage());
            if (event.getEventType() == EventType.COMPLETED) {
                LOG.infof("Successfully registered %s with platform", (Object)this.serviceName);
            } else if (event.getEventType() == EventType.FAILED) {
                LOG.errorf("Failed to register %s: %s", (Object)this.serviceName, (Object)event.getMessage());
                if (event.hasErrorDetail()) {
                    LOG.error((Object)("Details: " + event.getErrorDetail()));
                }
            }
        }, throwable -> LOG.error((Object)"Registration failed", throwable), () -> LOG.debug((Object)"Registration stream completed"));
    }

    public Multi<RegistrationEvent> registerService() {
        return this.grpcClientFactory.getPlatformRegistrationClient(REGISTRATION_SERVICE).onItem().transformToMulti(stub -> {
            ServiceRegistrationRequest request = this.buildServiceRequest();
            LOG.infof("Registering service: %s at %s:%d", (Object)this.serviceName, (Object)this.determineHost(), (Object)this.servicePort);
            return stub.registerService(request);
        }).onFailure().recoverWithMulti(throwable -> {
            LOG.error((Object)"Failed to connect to registration service", throwable);
            return Multi.createFrom().item((Object)RegistrationEvent.newBuilder().setEventType(EventType.FAILED).setMessage("Failed to connect to registration service").setErrorDetail(throwable.getMessage()).build());
        });
    }

    public Multi<RegistrationEvent> registerModule(ServiceRegistrationMetadata metadata) {
        return this.grpcClientFactory.getPlatformRegistrationClient(REGISTRATION_SERVICE).onItem().transformToMulti(stub -> {
            ModuleRegistrationRequest request = this.buildModuleRequest(metadata);
            LOG.infof("Registering module: %s at %s:%d", (Object)this.serviceName, (Object)this.determineHost(), (Object)this.servicePort);
            return stub.registerModule(request);
        }).onFailure().recoverWithMulti(throwable -> {
            LOG.error((Object)"Failed to connect to registration service", throwable);
            return Multi.createFrom().item((Object)RegistrationEvent.newBuilder().setEventType(EventType.FAILED).setMessage("Failed to connect to registration service").setErrorDetail(throwable.getMessage()).build());
        });
    }

    public Uni<UnregisterResponse> unregister() {
        return this.grpcClientFactory.getPlatformRegistrationClient(REGISTRATION_SERVICE).onItem().transformToUni(stub -> {
            UnregisterRequest request = UnregisterRequest.newBuilder().setServiceName(this.serviceName).setHost(this.determineHost()).setPort(this.servicePort).build();
            LOG.infof("Unregistering service: %s", (Object)this.serviceName);
            return stub.unregisterService(request);
        });
    }

    private ServiceRegistrationRequest buildServiceRequest() {
        ServiceRegistrationRequest.Builder builder = ServiceRegistrationRequest.newBuilder().setServiceName(this.serviceName).setHost(this.determineHost()).setPort(this.servicePort).setVersion(this.version);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("description", this.description);
        metadata.put("service-type", this.serviceType);
        metadata.put("profile", this.profile);
        builder.putAllMetadata(metadata);
        if (!this.capabilities.isEmpty()) {
            Arrays.stream(this.capabilities.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(arg_0 -> ((ServiceRegistrationRequest.Builder)builder).addCapabilities(arg_0));
        }
        if (!this.tags.isEmpty()) {
            Arrays.stream(this.tags.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(arg_0 -> ((ServiceRegistrationRequest.Builder)builder).addTags(arg_0));
        }
        return builder.build();
    }

    private ModuleRegistrationRequest buildModuleRequest(ServiceRegistrationMetadata metadata) {
        ModuleRegistrationRequest.Builder builder = ModuleRegistrationRequest.newBuilder().setModuleName(this.serviceName).setHost(this.determineHost()).setPort(this.servicePort).setVersion(this.version);
        if (metadata != null) {
            builder.setServiceRegistrationMetadata(metadata);
        }
        HashMap<String, String> additionalMetadata = new HashMap<String, String>();
        additionalMetadata.put("description", this.description);
        additionalMetadata.put("profile", this.profile);
        builder.putAllMetadata(additionalMetadata);
        return builder.build();
    }

    private String determineHost() {
        String envHost = System.getenv("SERVICE_REGISTRATION_HOST");
        if (envHost != null && !envHost.isEmpty()) {
            return envHost;
        }
        if ("dev".equals(this.profile) && "localhost".equals(this.serviceHost)) {
            return Optional.ofNullable(System.getenv("DOCKER_BRIDGE_IP")).orElse("172.17.0.1");
        }
        return this.serviceHost;
    }
}

