/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.dynamic.grpc.client;

import ai.pipestream.common.grpc.GrpcClientFactory;
import ai.pipestream.connector.intake.MutinyConnectorAdminServiceGrpc;
import ai.pipestream.data.module.MutinyPipeStepProcessorGrpc;
import ai.pipestream.dynamic.grpc.client.ChannelManager;
import ai.pipestream.dynamic.grpc.client.ServiceDiscoveryManager;
import ai.pipestream.opensearch.v1.MutinyOpenSearchManagerServiceGrpc;
import ai.pipestream.platform.registration.MutinyPlatformRegistrationGrpc;
import ai.pipestream.repository.account.MutinyAccountServiceGrpc;
import ai.pipestream.repository.filesystem.MutinyFilesystemServiceGrpc;
import ai.pipestream.repository.filesystem.upload.MutinyNodeUploadServiceGrpc;
import io.grpc.Channel;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.Status;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceInstance;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DynamicGrpcClientFactory
implements GrpcClientFactory {
    private static final Logger LOG = Logger.getLogger(DynamicGrpcClientFactory.class);
    @Inject
    ServiceDiscoveryManager serviceDiscoveryManager;
    @Inject
    ChannelManager channelManager;

    public Uni<MutinyPipeStepProcessorGrpc.MutinyPipeStepProcessorStub> getMutinyClientForService(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyPipeStepProcessorGrpc::newMutinyStub);
    }

    public Uni<MutinyPlatformRegistrationGrpc.MutinyPlatformRegistrationStub> getPlatformRegistrationClient(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyPlatformRegistrationGrpc::newMutinyStub);
    }

    public Uni<MutinyOpenSearchManagerServiceGrpc.MutinyOpenSearchManagerServiceStub> getOpenSearchManagerClient(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyOpenSearchManagerServiceGrpc::newMutinyStub);
    }

    public Uni<MutinyAccountServiceGrpc.MutinyAccountServiceStub> getAccountServiceClient(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyAccountServiceGrpc::newMutinyStub);
    }

    public Uni<MutinyConnectorAdminServiceGrpc.MutinyConnectorAdminServiceStub> getConnectorAdminServiceClient(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyConnectorAdminServiceGrpc::newMutinyStub);
    }

    public Uni<MutinyFilesystemServiceGrpc.MutinyFilesystemServiceStub> getFilesystemServiceClient(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyFilesystemServiceGrpc::newMutinyStub);
    }

    public Uni<MutinyNodeUploadServiceGrpc.MutinyNodeUploadServiceStub> getNodeUploadServiceClient(String serviceName) {
        this.validateServiceName(serviceName);
        return this.getChannel(serviceName).map(MutinyNodeUploadServiceGrpc::newMutinyStub);
    }

    private Uni<Channel> getChannel(String serviceName) {
        if (serviceName == null || serviceName.isBlank()) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Service name must not be null or blank"));
        }
        return this.serviceDiscoveryManager.ensureServiceDefined(serviceName).chain(ignored -> {
            LOG.infof("Step 1: Service %s defined", (Object)serviceName);
            return this.serviceDiscoveryManager.getServiceInstances(serviceName);
        }).chain(instances -> {
            LOG.infof("Step 2: Got %s instances for %s", (Object)instances.size(), (Object)serviceName);
            try {
                LOG.debugf("Step 2a: instances list type=%s, elementType=%s", (Object)instances.getClass().getName(), (Object)(instances.isEmpty() ? "<empty>" : ((ServiceInstance)instances.get(0)).getClass().getName()));
            }
            catch (Exception e) {
                LOG.debugf("Step 2a: Unable to inspect instances list: %s", (Object)e.getMessage());
            }
            Uni<Channel> channelUni = this.channelManager.getOrCreateChannel(serviceName, (List<ServiceInstance>)instances);
            LOG.infof("Step 2b: channelUni type: %s", (Object)channelUni.getClass().getName());
            return channelUni;
        });
    }

    private void validateServiceName(String serviceName) {
        if (serviceName == null || serviceName.isBlank()) {
            throw new IllegalArgumentException("Service name must not be null or blank");
        }
    }

    public int getActiveServiceCount() {
        return this.channelManager.getActiveServiceCount();
    }

    public void evictChannel(String serviceName) {
        this.channelManager.evictChannel(serviceName);
    }

    public String getCacheStats() {
        return this.channelManager.getCacheStats();
    }

    public static class StorkNameResolver
    extends NameResolver {
        private final String serviceName;
        private NameResolver.Listener2 listener;

        public StorkNameResolver(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceAuthority() {
            return this.serviceName;
        }

        public void start(NameResolver.Listener2 listener) {
            this.listener = listener;
            this.resolve();
        }

        public void refresh() {
            this.resolve();
        }

        private void resolve() {
            try {
                Service service = Stork.getInstance().getService(this.serviceName);
                service.getInstances().onItem().invoke(instances -> {
                    if (instances.isEmpty()) {
                        LOG.warnf("No instances found for service: %s", (Object)this.serviceName);
                        this.listener.onError(Status.UNAVAILABLE.withDescription("No instances found for service " + this.serviceName));
                    } else {
                        List addresses = instances.stream().map(i -> new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(i.getHost(), i.getPort()))).collect(Collectors.toList());
                        this.listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(addresses).build());
                    }
                }).subscribe().asCompletionStage();
            }
            catch (Exception e) {
                LOG.errorf((Throwable)e, "Failed to resolve service instances for %s", (Object)this.serviceName);
                this.listener.onError(Status.INTERNAL.withCause((Throwable)e).withDescription("Failed to resolve instances"));
            }
        }

        public void shutdown() {
        }
    }

    public static class StorkNameResolverProvider
    extends NameResolverProvider {
        private final String serviceName;

        public StorkNameResolverProvider(String serviceName) {
            this.serviceName = serviceName;
        }

        protected boolean isAvailable() {
            return true;
        }

        protected int priority() {
            return 5;
        }

        public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            return new StorkNameResolver(this.serviceName);
        }

        public String getDefaultScheme() {
            return "stork";
        }
    }
}

