/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.dynamic.grpc.client;

import ai.pipestream.dynamic.grpc.client.discovery.ServiceDiscovery;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkus.cache.CacheResult;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GrpcClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcClientProvider.class);
    private static final String CHANNEL_CACHE_NAME = "grpc-channels";
    @Inject
    ServiceDiscovery serviceDiscovery;
    private final Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();

    public <T> T getClient(Class<T> stubClass, String host, int port) {
        String key = host + ":" + port;
        ManagedChannel channel = this.channels.computeIfAbsent(key, k -> {
            LOG.info("Creating new gRPC channel for {}", (Object)key);
            return ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        });
        return this.createStub(stubClass, (Channel)channel);
    }

    @CacheResult(cacheName="grpc-channels")
    public <T> Uni<T> getClientForService(Class<T> stubClass, String serviceName) {
        return this.serviceDiscovery.discoverService(serviceName).map(instance -> {
            LOG.debug("Discovered service {} at {}:{}", new Object[]{serviceName, instance.getHost(), instance.getPort()});
            return this.getClient(stubClass, instance.getHost(), instance.getPort());
        });
    }

    public <T> Uni<T> getClientForServiceUncached(Class<T> stubClass, String serviceName) {
        return this.serviceDiscovery.discoverService(serviceName).map(instance -> {
            LOG.debug("Discovered service {} at {}:{} (uncached)", new Object[]{serviceName, instance.getHost(), instance.getPort()});
            return this.getClient(stubClass, instance.getHost(), instance.getPort());
        });
    }

    private <T> T createStub(Class<T> stubClass, Channel channel) {
        try {
            Class<?> grpcClass = stubClass.getEnclosingClass();
            if (grpcClass == null) {
                throw new IllegalArgumentException("Stub class must be a nested class of a gRPC service class");
            }
            Method newStubMethod = grpcClass.getMethod("newMutinyStub", Channel.class);
            return (T)newStubMethod.invoke(null, channel);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create Mutiny stub for " + stubClass.getName(), e);
        }
    }

    @PreDestroy
    void shutdown() {
        LOG.info("Shutting down {} gRPC channels", (Object)this.channels.size());
        this.channels.forEach((key, channel) -> {
            try {
                LOG.debug("Shutting down channel for {}", key);
                channel.shutdown();
                if (!channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.warn("Channel {} did not terminate gracefully, forcing shutdown", key);
                    channel.shutdownNow();
                }
            }
            catch (Exception e) {
                LOG.error("Error shutting down channel {}", key, (Object)e);
                try {
                    channel.shutdownNow();
                }
                catch (Exception ex) {
                    LOG.error("Error forcing shutdown of channel {}", key, (Object)ex);
                }
            }
        });
        this.channels.clear();
    }

    public int getActiveChannelCount() {
        return this.channels.size();
    }

    public boolean hasChannel(String host, int port) {
        return this.channels.containsKey(host + ":" + port);
    }
}

