/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.dynamic.grpc.client;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceDefinition;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ServiceDiscoveryManager {
    private static final Logger LOG = Logger.getLogger(ServiceDiscoveryManager.class);
    @ConfigProperty(name="pipeline.consul.host", defaultValue="localhost")
    String consulHost;
    @ConfigProperty(name="pipeline.consul.port", defaultValue="8500")
    String consulPort;
    @ConfigProperty(name="pipeline.consul.refresh-period", defaultValue="10s")
    String consulRefreshPeriod;
    @ConfigProperty(name="pipeline.consul.use-health-checks", defaultValue="false")
    boolean consulUseHealthChecks;

    public Uni<Void> ensureServiceDefined(String serviceName) {
        return this.ensureServiceDefinedFor(serviceName, serviceName);
    }

    public Uni<Void> ensureServiceDefinedFor(String storkServiceName, String consulApplicationName) {
        Optional existingService = Stork.getInstance().getServiceOptional(storkServiceName);
        if (existingService.isPresent()) {
            LOG.debugf("Service %s already defined in Stork", (Object)storkServiceName);
            return Uni.createFrom().voidItem();
        }
        LOG.infof("Defining new Stork service for dynamic discovery: %s (consul application: %s)", (Object)storkServiceName, (Object)consulApplicationName);
        HashMap<String, String> consulParams = new HashMap<String, String>();
        consulParams.put("consul-host", this.consulHost);
        consulParams.put("consul-port", this.consulPort);
        consulParams.put("refresh-period", this.consulRefreshPeriod);
        consulParams.put("use-health-checks", String.valueOf(this.consulUseHealthChecks));
        Config config = ConfigProvider.getConfig();
        String overrideKey = "pipeline.consul.application-name." + storkServiceName;
        String applicationToDiscover = config.getOptionalValue(overrideKey, String.class).orElse(consulApplicationName);
        consulParams.put("application", applicationToDiscover);
        SimpleServiceConfig.SimpleServiceDiscoveryConfig consulConfig = new SimpleServiceConfig.SimpleServiceDiscoveryConfig("consul", consulParams);
        ServiceDefinition definition = ServiceDefinition.of((ConfigWithType)consulConfig);
        try {
            Stork.getInstance().defineIfAbsent(storkServiceName, definition);
            LOG.infof("Successfully defined Stork service: %s with Consul discovery", (Object)storkServiceName);
            LOG.debugf("Stork will look for Consul service named: %s (overrideKey=%s, use-health-checks=%s)", (Object)applicationToDiscover, (Object)overrideKey, (Object)String.valueOf(this.consulUseHealthChecks));
            return Uni.createFrom().voidItem();
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to define Stork service: %s", (Object)storkServiceName);
            return Uni.createFrom().failure((Throwable)e);
        }
    }

    public Uni<List<ServiceInstance>> getServiceInstances(String serviceName) {
        try {
            Service service = Stork.getInstance().getService(serviceName);
            return service.getInstances();
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to get service instances for %s", (Object)serviceName);
            return Uni.createFrom().failure((Throwable)e);
        }
    }
}

