/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.dynamic.grpc.client.discovery;

import ai.pipestream.dynamic.grpc.client.discovery.RandomLoadBalancer;
import ai.pipestream.dynamic.grpc.client.discovery.ServiceDiscovery;
import ai.pipestream.dynamic.grpc.client.discovery.ServiceDiscoveryImpl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.Metadata;
import io.smallrye.stork.api.MetadataKey;
import io.smallrye.stork.api.ServiceInstance;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.ServiceEntry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={DynamicConsulServiceDiscovery.class})
@ServiceDiscoveryImpl(value=ServiceDiscoveryImpl.Type.CONSUL_DIRECT)
public class DynamicConsulServiceDiscovery
implements ServiceDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicConsulServiceDiscovery.class);
    @Inject
    Vertx vertx;
    @ConfigProperty(name="quarkus.consul.host", defaultValue="localhost")
    String consulHost;
    @ConfigProperty(name="quarkus.consul.port", defaultValue="8500")
    int consulPort;
    private ConsulClient consulClient;
    private final LoadBalancer loadBalancer = new RandomLoadBalancer();

    @PostConstruct
    void init() {
        LOG.info("Creating ConsulClient for service discovery on {}:{}", (Object)this.consulHost, (Object)this.consulPort);
        ConsulClientOptions options = new ConsulClientOptions().setHost(this.consulHost).setPort(this.consulPort);
        this.consulClient = ConsulClient.create((Vertx)this.vertx, (ConsulClientOptions)options);
        LOG.info("ConsulClient connected to {}:{}", (Object)this.consulHost, (Object)this.consulPort);
    }

    @PreDestroy
    void cleanup() {
        if (this.consulClient != null) {
            LOG.info("Closing ConsulClient");
            this.consulClient.close();
        }
    }

    @Override
    public Uni<ServiceInstance> discoverService(String serviceName) {
        LOG.debug("Discovering service {} dynamically from Consul", (Object)serviceName);
        return this.findHealthyInstances(serviceName).map(instances -> {
            if (instances == null || instances.isEmpty()) {
                throw new ServiceDiscoveryException("No healthy instances found for service: " + serviceName);
            }
            ArrayList<StorkServiceInstanceAdapter> storkInstances = new ArrayList<StorkServiceInstanceAdapter>();
            long id = 0L;
            for (ServiceEntry entry : instances) {
                storkInstances.add(new StorkServiceInstanceAdapter(id++, entry.getService().getAddress(), entry.getService().getPort()));
            }
            ServiceInstance selected = this.loadBalancer.selectServiceInstance(storkInstances);
            LOG.debug("Selected instance for service {}: {}:{} (id={})", new Object[]{serviceName, selected.getHost(), selected.getPort(), selected.getId()});
            return new ConsulServiceInstance(String.valueOf(selected.getId()), selected.getHost(), selected.getPort(), serviceName);
        });
    }

    @Override
    public Uni<List<ServiceInstance>> discoverAllInstances(String serviceName) {
        LOG.debug("Discovering all instances for service {} from Consul", (Object)serviceName);
        return this.findHealthyInstances(serviceName).map(instances -> {
            if (instances == null) {
                return List.of();
            }
            return instances.stream().map(entry -> {
                String host = entry.getService().getAddress();
                int port = entry.getService().getPort();
                String id = entry.getService().getId();
                return new ConsulServiceInstance(id, host, port, serviceName);
            }).collect(Collectors.toList());
        });
    }

    private Uni<List<ServiceEntry>> findHealthyInstances(String serviceName) {
        if (this.consulClient == null) {
            throw new ServiceDiscoveryException("ConsulClient not initialized. Check configuration.");
        }
        return UniHelper.toUni((Future)this.consulClient.healthServiceNodes(serviceName, true)).map(serviceList -> {
            if (serviceList == null || serviceList.getList() == null) {
                LOG.warn("No healthy nodes found for service '{}' in Consul", (Object)serviceName);
                return List.of();
            }
            LOG.debug("Found {} healthy instances for service '{}'", (Object)serviceList.getList().size(), (Object)serviceName);
            List list = serviceList.getList();
            try {
                LOG.debug("Consul serviceList type={}, list type={}, first element type={}", new Object[]{serviceList.getClass().getName(), list.getClass().getName(), list.isEmpty() ? "<empty>" : ((ServiceEntry)list.get(0)).getClass().getName()});
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
        }).onFailure().invoke(error -> LOG.error("Failed to query Consul for service '{}'", (Object)serviceName, error)).map(list -> list);
    }

    public static class ServiceDiscoveryException
    extends RuntimeException {
        public ServiceDiscoveryException(String message) {
            super(message);
        }

        public ServiceDiscoveryException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ConsulServiceInstance
    implements ServiceInstance {
        private final String id;
        private final String host;
        private final int port;
        private final String serviceName;

        ConsulServiceInstance(String id, String host, int port, String serviceName) {
            this.id = id;
            this.host = host;
            this.port = port;
            this.serviceName = serviceName;
        }

        public long getId() {
            return Long.parseLong(this.id.replaceAll("[^0-9]", "").substring(0, Math.min(8, this.id.replaceAll("[^0-9]", "").length())));
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return false;
        }

        public Optional<String> getPath() {
            return Optional.empty();
        }

        public Metadata<? extends MetadataKey> getMetadata() {
            return Metadata.empty();
        }
    }

    private static class StorkServiceInstanceAdapter
    implements ServiceInstance {
        private final long id;
        private final String host;
        private final int port;

        StorkServiceInstanceAdapter(long id, String host, int port) {
            this.id = id;
            this.host = host;
            this.port = port;
        }

        public long getId() {
            return this.id;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return false;
        }

        public Optional<String> getPath() {
            return Optional.empty();
        }

        public Metadata<? extends MetadataKey> getMetadata() {
            return Metadata.empty();
        }
    }
}

