/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.dynamic.grpc.util;

import org.jboss.logging.Logger;

public class HostnameResolver {
    private static final Logger LOG = Logger.getLogger(HostnameResolver.class);

    private HostnameResolver() {
    }

    public static String resolveHostname(String serviceName) {
        try {
            String serviceEnvVar;
            String serviceHost;
            if (serviceName != null && !serviceName.isEmpty() && (serviceHost = System.getenv(serviceEnvVar = serviceName.toUpperCase().replace("-", "_") + "_HOST")) != null && !serviceHost.isEmpty()) {
                LOG.infof("Using service-specific hostname from %s: %s", (Object)serviceEnvVar, (Object)serviceHost);
                return serviceHost;
            }
            String genericHost = System.getenv("SERVICE_HOST");
            if (genericHost != null && !genericHost.isEmpty()) {
                LOG.infof("Using generic SERVICE_HOST: %s", (Object)genericHost);
                return genericHost;
            }
            String containerHost = System.getenv("HOSTNAME");
            if (containerHost != null && !containerHost.isEmpty()) {
                LOG.infof("Using container HOSTNAME: %s", (Object)containerHost);
                return containerHost;
            }
            LOG.info((Object)"Using fallback hostname: localhost");
            return "localhost";
        }
        catch (Exception e) {
            LOG.warnf((Throwable)e, "Error resolving hostname, using localhost fallback", new Object[0]);
            return "localhost";
        }
    }

    public static String resolveHostname() {
        return HostnameResolver.resolveHostname(null);
    }

    public static void logHostnameResolution(String serviceName) {
        String hostname = HostnameResolver.resolveHostname(serviceName);
        LOG.infof("=== HOSTNAME RESOLUTION DEBUG ===", new Object[0]);
        LOG.infof("Service: %s", (Object)serviceName);
        LOG.infof("Resolved hostname: %s", (Object)hostname);
        if (serviceName != null) {
            String serviceEnvVar = serviceName.toUpperCase().replace("-", "_") + "_HOST";
            LOG.infof("  %s = %s", (Object)serviceEnvVar, (Object)System.getenv(serviceEnvVar));
        }
        LOG.infof("  SERVICE_HOST = %s", (Object)System.getenv("SERVICE_HOST"));
        LOG.infof("  HOSTNAME = %s", (Object)System.getenv("HOSTNAME"));
        LOG.infof("=== END HOSTNAME RESOLUTION ===", new Object[0]);
    }
}

