/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.data.module;

import ai.pipestream.data.module.ModuleProcessRequest;
import ai.pipestream.data.module.ModuleProcessResponse;
import ai.pipestream.data.module.PipeStepProcessorGrpc;
import ai.pipestream.data.module.RegistrationRequest;
import ai.pipestream.data.module.ServiceRegistrationMetadata;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.MutinyGrpc;
import io.quarkus.grpc.MutinyStub;
import io.quarkus.grpc.stubs.ClientCalls;
import io.smallrye.mutiny.Uni;

public final class MutinyPipeStepProcessorGrpc
implements MutinyGrpc {
    private static final int METHODID_PROCESS_DATA = 0;
    private static final int METHODID_TEST_PROCESS_DATA = 1;
    private static final int METHODID_GET_SERVICE_REGISTRATION = 2;

    private MutinyPipeStepProcessorGrpc() {
    }

    public static MutinyPipeStepProcessorStub newMutinyStub(Channel channel) {
        return new MutinyPipeStepProcessorStub(channel);
    }

    public static class MutinyPipeStepProcessorStub
    extends AbstractStub<MutinyPipeStepProcessorStub>
    implements MutinyStub {
        private PipeStepProcessorGrpc.PipeStepProcessorStub delegateStub;

        private MutinyPipeStepProcessorStub(Channel channel) {
            super(channel);
            this.delegateStub = PipeStepProcessorGrpc.newStub(channel);
        }

        private MutinyPipeStepProcessorStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = PipeStepProcessorGrpc.newStub(channel).build(channel, callOptions);
        }

        protected MutinyPipeStepProcessorStub build(Channel channel, CallOptions callOptions) {
            return new MutinyPipeStepProcessorStub(channel, callOptions);
        }

        public Uni<ModuleProcessResponse> processData(ModuleProcessRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::processData);
        }

        public Uni<ModuleProcessResponse> testProcessData(ModuleProcessRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::testProcessData);
        }

        public Uni<ServiceRegistrationMetadata> getServiceRegistration(RegistrationRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::getServiceRegistration);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final PipeStepProcessorImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(PipeStepProcessorImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((ModuleProcessRequest)request), responseObserver, (String)this.compression, this.serviceImpl::processData);
                    break;
                }
                case 1: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((ModuleProcessRequest)request), responseObserver, (String)this.compression, this.serviceImpl::testProcessData);
                    break;
                }
                case 2: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((RegistrationRequest)request), responseObserver, (String)this.compression, this.serviceImpl::getServiceRegistration);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class PipeStepProcessorImplBase
    implements BindableService {
        private String compression;

        public PipeStepProcessorImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Uni<ModuleProcessResponse> processData(ModuleProcessRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<ModuleProcessResponse> testProcessData(ModuleProcessRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<ServiceRegistrationMetadata> getServiceRegistration(RegistrationRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)PipeStepProcessorGrpc.getServiceDescriptor()).addMethod(PipeStepProcessorGrpc.getProcessDataMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(PipeStepProcessorGrpc.getTestProcessDataMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(PipeStepProcessorGrpc.getGetServiceRegistrationMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).build();
        }
    }
}

