/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.engine.v1;

import ai.pipestream.engine.v1.EngineV1ServiceGrpc;
import ai.pipestream.engine.v1.GetTopicSubscriptionsRequest;
import ai.pipestream.engine.v1.GetTopicSubscriptionsResponse;
import ai.pipestream.engine.v1.HealthRequest;
import ai.pipestream.engine.v1.HealthResponse;
import ai.pipestream.engine.v1.ProcessNodeRequest;
import ai.pipestream.engine.v1.ProcessNodeResponse;
import ai.pipestream.engine.v1.RouteToClusterRequest;
import ai.pipestream.engine.v1.RouteToClusterResponse;
import ai.pipestream.engine.v1.UpdateTopicSubscriptionsRequest;
import ai.pipestream.engine.v1.UpdateTopicSubscriptionsResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.MutinyGrpc;
import io.quarkus.grpc.MutinyStub;
import io.quarkus.grpc.stubs.ClientCalls;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;

public final class MutinyEngineV1ServiceGrpc
implements MutinyGrpc {
    private static final int METHODID_PROCESS_NODE = 0;
    private static final int METHODID_PROCESS_STREAM = 1;
    private static final int METHODID_ROUTE_TO_CLUSTER = 2;
    private static final int METHODID_UPDATE_TOPIC_SUBSCRIPTIONS = 3;
    private static final int METHODID_GET_TOPIC_SUBSCRIPTIONS = 4;
    private static final int METHODID_GET_HEALTH = 5;

    private MutinyEngineV1ServiceGrpc() {
    }

    public static MutinyEngineV1ServiceStub newMutinyStub(Channel channel) {
        return new MutinyEngineV1ServiceStub(channel);
    }

    public static class MutinyEngineV1ServiceStub
    extends AbstractStub<MutinyEngineV1ServiceStub>
    implements MutinyStub {
        private EngineV1ServiceGrpc.EngineV1ServiceStub delegateStub;

        private MutinyEngineV1ServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = EngineV1ServiceGrpc.newStub(channel);
        }

        private MutinyEngineV1ServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = EngineV1ServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        protected MutinyEngineV1ServiceStub build(Channel channel, CallOptions callOptions) {
            return new MutinyEngineV1ServiceStub(channel, callOptions);
        }

        public Uni<ProcessNodeResponse> processNode(ProcessNodeRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::processNode);
        }

        public Uni<RouteToClusterResponse> routeToCluster(RouteToClusterRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::routeToCluster);
        }

        public Uni<UpdateTopicSubscriptionsResponse> updateTopicSubscriptions(UpdateTopicSubscriptionsRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::updateTopicSubscriptions);
        }

        public Uni<GetTopicSubscriptionsResponse> getTopicSubscriptions(GetTopicSubscriptionsRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::getTopicSubscriptions);
        }

        public Uni<HealthResponse> getHealth(HealthRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::getHealth);
        }

        public Multi<ProcessNodeResponse> processStream(Multi<ProcessNodeRequest> request) {
            return ClientCalls.manyToMany(request, this.delegateStub::processStream);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final EngineV1ServiceImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(EngineV1ServiceImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((ProcessNodeRequest)request), responseObserver, (String)this.compression, this.serviceImpl::processNode);
                    break;
                }
                case 2: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((RouteToClusterRequest)request), responseObserver, (String)this.compression, this.serviceImpl::routeToCluster);
                    break;
                }
                case 3: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((UpdateTopicSubscriptionsRequest)request), responseObserver, (String)this.compression, this.serviceImpl::updateTopicSubscriptions);
                    break;
                }
                case 4: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((GetTopicSubscriptionsRequest)request), responseObserver, (String)this.compression, this.serviceImpl::getTopicSubscriptions);
                    break;
                }
                case 5: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((HealthRequest)request), responseObserver, (String)this.compression, this.serviceImpl::getHealth);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return io.quarkus.grpc.stubs.ServerCalls.manyToMany(responseObserver, this.serviceImpl::processStream);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class EngineV1ServiceImplBase
    implements BindableService {
        private String compression;

        public EngineV1ServiceImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Uni<ProcessNodeResponse> processNode(ProcessNodeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<RouteToClusterResponse> routeToCluster(RouteToClusterRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<UpdateTopicSubscriptionsResponse> updateTopicSubscriptions(UpdateTopicSubscriptionsRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<GetTopicSubscriptionsResponse> getTopicSubscriptions(GetTopicSubscriptionsRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<HealthResponse> getHealth(HealthRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Multi<ProcessNodeResponse> processStream(Multi<ProcessNodeRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)EngineV1ServiceGrpc.getServiceDescriptor()).addMethod(EngineV1ServiceGrpc.getProcessNodeMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(EngineV1ServiceGrpc.getProcessStreamMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1, this.compression))).addMethod(EngineV1ServiceGrpc.getRouteToClusterMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).addMethod(EngineV1ServiceGrpc.getUpdateTopicSubscriptionsMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3, this.compression))).addMethod(EngineV1ServiceGrpc.getGetTopicSubscriptionsMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 4, this.compression))).addMethod(EngineV1ServiceGrpc.getGetHealthMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 5, this.compression))).build();
        }
    }
}

