/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.testing.harness.grpc;

import ai.pipestream.testing.harness.grpc.ModuleStatus;
import ai.pipestream.testing.harness.grpc.TestCommand;
import ai.pipestream.testing.harness.grpc.TestEvent;
import ai.pipestream.testing.harness.grpc.TestHarnessGrpc;
import ai.pipestream.testing.harness.grpc.TestResult;
import com.google.protobuf.Empty;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.MutinyGrpc;
import io.quarkus.grpc.MutinyStub;
import io.quarkus.grpc.stubs.ClientCalls;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;

public final class MutinyTestHarnessGrpc
implements MutinyGrpc {
    private static final int METHODID_EXECUTE_TEST_STREAM = 0;
    private static final int METHODID_EXECUTE_TEST = 1;
    private static final int METHODID_GET_MODULE_STATUS = 2;

    private MutinyTestHarnessGrpc() {
    }

    public static MutinyTestHarnessStub newMutinyStub(Channel channel) {
        return new MutinyTestHarnessStub(channel);
    }

    public static class MutinyTestHarnessStub
    extends AbstractStub<MutinyTestHarnessStub>
    implements MutinyStub {
        private TestHarnessGrpc.TestHarnessStub delegateStub;

        private MutinyTestHarnessStub(Channel channel) {
            super(channel);
            this.delegateStub = TestHarnessGrpc.newStub(channel);
        }

        private MutinyTestHarnessStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = TestHarnessGrpc.newStub(channel).build(channel, callOptions);
        }

        protected MutinyTestHarnessStub build(Channel channel, CallOptions callOptions) {
            return new MutinyTestHarnessStub(channel, callOptions);
        }

        public Uni<TestResult> executeTest(TestCommand request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::executeTest);
        }

        public Uni<ModuleStatus> getModuleStatus(Empty request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::getModuleStatus);
        }

        public Multi<TestEvent> executeTestStream(Multi<TestCommand> request) {
            return ClientCalls.manyToMany(request, this.delegateStub::executeTestStream);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final TestHarnessImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(TestHarnessImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((TestCommand)request), responseObserver, (String)this.compression, this.serviceImpl::executeTest);
                    break;
                }
                case 2: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((Empty)request), responseObserver, (String)this.compression, this.serviceImpl::getModuleStatus);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return io.quarkus.grpc.stubs.ServerCalls.manyToMany(responseObserver, this.serviceImpl::executeTestStream);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class TestHarnessImplBase
    implements BindableService {
        private String compression;

        public TestHarnessImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Uni<TestResult> executeTest(TestCommand request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<ModuleStatus> getModuleStatus(Empty request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Multi<TestEvent> executeTestStream(Multi<TestCommand> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)TestHarnessGrpc.getServiceDescriptor()).addMethod(TestHarnessGrpc.getExecuteTestStreamMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0, this.compression))).addMethod(TestHarnessGrpc.getExecuteTestMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(TestHarnessGrpc.getGetModuleStatusMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).build();
        }
    }
}

