/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.validation.v1;

import ai.pipestream.validation.v1.ValidateGraphRequest;
import ai.pipestream.validation.v1.ValidateModuleRequest;
import ai.pipestream.validation.v1.ValidateNodeRequest;
import ai.pipestream.validation.v1.ValidationResponse;
import ai.pipestream.validation.v1.ValidationServiceGrpc;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.MutinyGrpc;
import io.quarkus.grpc.MutinyStub;
import io.quarkus.grpc.stubs.ClientCalls;
import io.smallrye.mutiny.Uni;

public final class MutinyValidationServiceGrpc
implements MutinyGrpc {
    private static final int METHODID_VALIDATE_NODE = 0;
    private static final int METHODID_VALIDATE_GRAPH = 1;
    private static final int METHODID_VALIDATE_MODULE = 2;

    private MutinyValidationServiceGrpc() {
    }

    public static MutinyValidationServiceStub newMutinyStub(Channel channel) {
        return new MutinyValidationServiceStub(channel);
    }

    public static class MutinyValidationServiceStub
    extends AbstractStub<MutinyValidationServiceStub>
    implements MutinyStub {
        private ValidationServiceGrpc.ValidationServiceStub delegateStub;

        private MutinyValidationServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = ValidationServiceGrpc.newStub(channel);
        }

        private MutinyValidationServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ValidationServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        protected MutinyValidationServiceStub build(Channel channel, CallOptions callOptions) {
            return new MutinyValidationServiceStub(channel, callOptions);
        }

        public Uni<ValidationResponse> validateNode(ValidateNodeRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::validateNode);
        }

        public Uni<ValidationResponse> validateGraph(ValidateGraphRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::validateGraph);
        }

        public Uni<ValidationResponse> validateModule(ValidateModuleRequest request) {
            return ClientCalls.oneToOne((Object)request, this.delegateStub::validateModule);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ValidationServiceImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ValidationServiceImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((ValidateNodeRequest)request), responseObserver, (String)this.compression, this.serviceImpl::validateNode);
                    break;
                }
                case 1: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((ValidateGraphRequest)request), responseObserver, (String)this.compression, this.serviceImpl::validateGraph);
                    break;
                }
                case 2: {
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((Object)((ValidateModuleRequest)request), responseObserver, (String)this.compression, this.serviceImpl::validateModule);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class ValidationServiceImplBase
    implements BindableService {
        private String compression;

        public ValidationServiceImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Uni<ValidationResponse> validateNode(ValidateNodeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<ValidationResponse> validateGraph(ValidateGraphRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Uni<ValidationResponse> validateModule(ValidateModuleRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)ValidationServiceGrpc.getServiceDescriptor()).addMethod(ValidationServiceGrpc.getValidateNodeMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(ValidationServiceGrpc.getValidateGraphMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(ValidationServiceGrpc.getValidateModuleMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).build();
        }
    }
}

