/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.grpc.wiremock;

import ai.pipestream.grpc.wiremock.WireMockGrpcCompat;
import ai.pipestream.repository.account.Account;
import ai.pipestream.repository.account.CreateAccountResponse;
import ai.pipestream.repository.account.GetAccountRequest;
import ai.pipestream.repository.account.InactivateAccountResponse;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Timestamp;
import org.wiremock.grpc.dsl.WireMockGrpc;
import org.wiremock.grpc.dsl.WireMockGrpcService;

public class AccountManagerMock {
    private final WireMockGrpcService mockService;

    public AccountManagerMock(int wireMockPort) {
        this.mockService = new WireMockGrpcService(new WireMock(wireMockPort), "ai.pipestream.repository.account.AccountService");
    }

    public AccountManagerMock mockCreateAccount(String accountId, String name, String description) {
        this.mockService.stubFor(WireMockGrpcCompat.method("CreateAccount").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)CreateAccountResponse.newBuilder().setAccount(Account.newBuilder().setAccountId(accountId).setName(name).setDescription(description).setActive(true).setCreatedAt(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() / 1000L).setNanos((int)(System.currentTimeMillis() % 1000L * 1000000L)).build()).setUpdatedAt(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() / 1000L).setNanos((int)(System.currentTimeMillis() % 1000L * 1000000L)).build()).build()).setCreated(true).build())));
        return this;
    }

    public AccountManagerMock mockCreateAccountExists(String accountId, String name, String description) {
        this.mockService.stubFor(WireMockGrpcCompat.method("CreateAccount").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)CreateAccountResponse.newBuilder().setAccount(Account.newBuilder().setAccountId(accountId).setName(name).setDescription(description).setActive(true).setCreatedAt(Timestamp.newBuilder().setSeconds((System.currentTimeMillis() - 1000L) / 1000L).setNanos((int)((System.currentTimeMillis() - 1000L) % 1000L * 1000000L)).build()).setUpdatedAt(Timestamp.newBuilder().setSeconds((System.currentTimeMillis() - 1000L) / 1000L).setNanos((int)((System.currentTimeMillis() - 1000L) % 1000L * 1000000L)).build()).build()).setCreated(false).build())));
        return this;
    }

    public AccountManagerMock mockAccountNotFound(String accountId) {
        this.mockService.stubFor(WireMockGrpcCompat.method("GetAccount").withRequestMessage(WireMockGrpcCompat.equalToMessage((MessageOrBuilder)GetAccountRequest.newBuilder().setAccountId(accountId).build())).willReturn(WireMockGrpc.Status.NOT_FOUND, "Account not found: " + accountId));
        return this;
    }

    public AccountManagerMock mockGetAccount(String accountId, String name, String description, boolean active) {
        this.mockService.stubFor(WireMockGrpcCompat.method("GetAccount").withRequestMessage(WireMockGrpcCompat.equalToMessage((MessageOrBuilder)GetAccountRequest.newBuilder().setAccountId(accountId).build())).willReturn(WireMockGrpcCompat.message((MessageOrBuilder)Account.newBuilder().setAccountId(accountId).setName(name).setDescription(description).setActive(active).setCreatedAt(Timestamp.newBuilder().setSeconds((System.currentTimeMillis() - 1000L) / 1000L).setNanos((int)((System.currentTimeMillis() - 1000L) % 1000L * 1000000L)).build()).setUpdatedAt(Timestamp.newBuilder().setSeconds((System.currentTimeMillis() - 1000L) / 1000L).setNanos((int)((System.currentTimeMillis() - 1000L) % 1000L * 1000000L)).build()).build())));
        return this;
    }

    public AccountManagerMock mockInactivateAccount(String accountId) {
        this.mockService.stubFor(WireMockGrpcCompat.method("InactivateAccount").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)InactivateAccountResponse.newBuilder().setSuccess(true).setMessage("Account inactivated successfully").setDrivesAffected(0).build())));
        return this;
    }

    public AccountManagerMock mockInactivateAccountNotFound(String accountId) {
        this.mockService.stubFor(WireMockGrpcCompat.method("InactivateAccount").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)InactivateAccountResponse.newBuilder().setSuccess(false).setMessage("Account not found: " + accountId).setDrivesAffected(0).build())));
        return this;
    }

    public WireMockGrpcService getService() {
        return this.mockService;
    }
}

