/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.grpc.wiremock;

import ai.pipestream.platform.registration.EventType;
import ai.pipestream.platform.registration.ModuleDetails;
import ai.pipestream.platform.registration.ModuleListResponse;
import ai.pipestream.platform.registration.ModuleRegistrationRequest;
import ai.pipestream.platform.registration.PlatformRegistrationGrpc;
import ai.pipestream.platform.registration.RegistrationEvent;
import ai.pipestream.platform.registration.ServiceDetails;
import ai.pipestream.platform.registration.ServiceListResponse;
import ai.pipestream.platform.registration.ServiceRegistrationRequest;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DirectWireMockGrpcServer {
    private final WireMockServer wireMockServer;
    private final Server grpcServer;
    private final int port;

    public DirectWireMockGrpcServer(int port) {
        this.port = port;
        this.wireMockServer = new WireMockServer(port);
        this.wireMockServer.start();
        this.grpcServer = ServerBuilder.forPort((int)0).addService((BindableService)new PlatformRegistrationServiceImpl(this)).build();
    }

    public void start() throws IOException {
        this.grpcServer.start();
    }

    public void stop() throws InterruptedException {
        this.grpcServer.shutdown();
        this.wireMockServer.stop();
        if (!this.grpcServer.awaitTermination(5L, TimeUnit.SECONDS)) {
            this.grpcServer.shutdownNow();
        }
    }

    public int getGrpcPort() {
        return this.grpcServer.getPort();
    }

    public WireMockServer getWireMockServer() {
        return this.wireMockServer;
    }

    private class PlatformRegistrationServiceImpl
    extends PlatformRegistrationGrpc.PlatformRegistrationImplBase {
        private PlatformRegistrationServiceImpl(DirectWireMockGrpcServer directWireMockGrpcServer) {
        }

        public void registerService(ServiceRegistrationRequest request, StreamObserver<RegistrationEvent> responseObserver) {
            try {
                responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(EventType.STARTED).setMessage("Starting service registration").build());
                Thread.sleep(100L);
                responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(EventType.VALIDATED).setMessage("Service registration request validated").build());
                Thread.sleep(100L);
                responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(EventType.CONSUL_REGISTERED).setMessage("Service registered with Consul").build());
                Thread.sleep(100L);
                responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(EventType.HEALTH_CHECK_CONFIGURED).setMessage("Health check configured").build());
                Thread.sleep(100L);
                responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(EventType.CONSUL_HEALTHY).setMessage("Service reported healthy by Consul").build());
                Thread.sleep(100L);
                responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(EventType.COMPLETED).setMessage("Service registration completed successfully").build());
                responseObserver.onCompleted();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Interrupted").asRuntimeException());
            }
        }

        public void registerModule(ModuleRegistrationRequest request, StreamObserver<RegistrationEvent> responseObserver) {
            try {
                EventType[] phases = new EventType[]{EventType.STARTED, EventType.VALIDATED, EventType.CONSUL_REGISTERED, EventType.HEALTH_CHECK_CONFIGURED, EventType.CONSUL_HEALTHY, EventType.METADATA_RETRIEVED, EventType.SCHEMA_VALIDATED, EventType.DATABASE_SAVED, EventType.APICURIO_REGISTERED, EventType.COMPLETED};
                String[] messages = new String[]{"Starting module registration", "Module registration request validated", "Module registered with Consul", "Health check configured", "Module reported healthy by Consul", "Module metadata retrieved", "Schema validated or synthesized", "Module registration saved to database", "Schema registered in Apicurio", "Module registration completed successfully"};
                for (int i = 0; i < phases.length; ++i) {
                    responseObserver.onNext((Object)RegistrationEvent.newBuilder().setEventType(phases[i]).setMessage(messages[i]).build());
                    Thread.sleep(50L);
                }
                responseObserver.onCompleted();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Interrupted").asRuntimeException());
            }
        }

        public void listServices(Empty request, StreamObserver<ServiceListResponse> responseObserver) {
            ServiceListResponse response = ServiceListResponse.newBuilder().addServices(ServiceDetails.newBuilder().setServiceName("repository-service").setServiceId("repo-1").setHost("localhost").setPort(8080).setVersion("1.0.0").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).addServices(ServiceDetails.newBuilder().setServiceName("account-manager").setServiceId("account-1").setHost("localhost").setPort(38105).setVersion("1.0.0").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).setAsOf(Timestamp.getDefaultInstance()).setTotalCount(2).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }

        public void listModules(Empty request, StreamObserver<ModuleListResponse> responseObserver) {
            ModuleListResponse response = ModuleListResponse.newBuilder().addModules(ModuleDetails.newBuilder().setModuleName("parser").setServiceId("parser-1").setHost("localhost").setPort(8081).setVersion("1.0.0").setInputFormat("text/plain").setOutputFormat("application/json").addDocumentTypes("text").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).addModules(ModuleDetails.newBuilder().setModuleName("chunker").setServiceId("chunker-1").setHost("localhost").setPort(8082).setVersion("1.0.0").setInputFormat("application/json").setOutputFormat("application/json").addDocumentTypes("text").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).setAsOf(Timestamp.getDefaultInstance()).setTotalCount(2).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }
}

