/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.grpc.wiremock;

import ai.pipestream.common.grpc.GrpcClientFactory;
import ai.pipestream.platform.registration.MutinyPlatformRegistrationGrpc;
import ai.pipestream.repository.account.MutinyAccountServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;

@Alternative
@ApplicationScoped
public class MockGrpcClientFactory
implements GrpcClientFactory {
    private final int wireMockPort = Integer.parseInt(System.getProperty("test.wiremock.port", "0"));
    private ManagedChannel mockChannel;

    public MockGrpcClientFactory() {
        if (this.wireMockPort > 0) {
            this.mockChannel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.wireMockPort).usePlaintext().build();
        }
    }

    public <T> Uni<T> getMutinyClientForService(String serviceName) {
        if (this.mockChannel == null) {
            return Uni.createFrom().failure((Throwable)new IllegalStateException("WireMock port not configured for testing"));
        }
        if ("platform-registration-service".equals(serviceName)) {
            return this.getPlatformRegistrationClient(serviceName);
        }
        return Uni.createFrom().failure((Throwable)new UnsupportedOperationException("Mock not implemented for service: " + serviceName));
    }

    public Uni<MutinyPlatformRegistrationGrpc.MutinyPlatformRegistrationStub> getPlatformRegistrationClient(String serviceName) {
        if (this.mockChannel == null) {
            return Uni.createFrom().failure((Throwable)new IllegalStateException("WireMock port not configured for testing"));
        }
        MutinyPlatformRegistrationGrpc.MutinyPlatformRegistrationStub client = MutinyPlatformRegistrationGrpc.newMutinyStub((Channel)this.mockChannel);
        return Uni.createFrom().item((Object)client);
    }

    public Uni<MutinyAccountServiceGrpc.MutinyAccountServiceStub> getAccountServiceClient(String serviceName) {
        if (this.mockChannel == null) {
            return Uni.createFrom().failure((Throwable)new IllegalStateException("WireMock port not configured for testing"));
        }
        MutinyAccountServiceGrpc.MutinyAccountServiceStub client = MutinyAccountServiceGrpc.newMutinyStub((Channel)this.mockChannel);
        return Uni.createFrom().item((Object)client);
    }

    public int getActiveServiceCount() {
        return this.mockChannel != null ? 1 : 0;
    }

    public void evictChannel(String serviceName) {
    }

    public String getCacheStats() {
        return "Mock gRPC client factory - routing to WireMock on port " + this.wireMockPort;
    }
}

