/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.grpc.wiremock;

import ai.pipestream.grpc.wiremock.DirectWireMockGrpcServer;
import ai.pipestream.platform.registration.PlatformRegistrationGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

public class MockServiceFactory {
    private static DirectWireMockGrpcServer mockServer;
    private static ManagedChannel mockChannel;

    public static void startMockPlatformRegistrationService() {
        try {
            if (mockServer == null) {
                mockServer = new DirectWireMockGrpcServer(0);
                mockServer.start();
                mockChannel = ManagedChannelBuilder.forAddress((String)"localhost", (int)mockServer.getGrpcPort()).usePlaintext().build();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start mock platform registration service", e);
        }
    }

    public static void stopMockPlatformRegistrationService() {
        try {
            if (mockChannel != null) {
                mockChannel.shutdown();
                mockChannel = null;
            }
            if (mockServer != null) {
                mockServer.stop();
                mockServer = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop mock platform registration service", e);
        }
    }

    public static PlatformRegistrationGrpc.PlatformRegistrationStub getPlatformRegistrationStub() {
        if (mockServer != null && mockChannel != null) {
            return PlatformRegistrationGrpc.newStub((Channel)mockChannel);
        }
        throw new IllegalStateException("Mock platform registration service not started. Call startMockPlatformRegistrationService() first.");
    }

    public static PlatformRegistrationGrpc.PlatformRegistrationBlockingStub getPlatformRegistrationBlockingStub() {
        if (mockServer != null && mockChannel != null) {
            return PlatformRegistrationGrpc.newBlockingStub((Channel)mockChannel);
        }
        throw new IllegalStateException("Mock platform registration service not started. Call startMockPlatformRegistrationService() first.");
    }

    public static boolean isMockServiceRunning() {
        return mockServer != null && mockChannel != null;
    }

    public static DirectWireMockGrpcServer getMockServer() {
        return mockServer;
    }
}

