/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.grpc.wiremock;

import ai.pipestream.grpc.wiremock.WireMockGrpcCompat;
import ai.pipestream.platform.registration.EventType;
import ai.pipestream.platform.registration.ModuleDetails;
import ai.pipestream.platform.registration.ModuleListResponse;
import ai.pipestream.platform.registration.RegistrationEvent;
import ai.pipestream.platform.registration.ServiceDetails;
import ai.pipestream.platform.registration.ServiceListResponse;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Timestamp;
import org.wiremock.grpc.dsl.WireMockGrpcService;

public class PlatformRegistrationMock {
    private final WireMockGrpcService mockService;

    public PlatformRegistrationMock(int wireMockPort) {
        this.mockService = new WireMockGrpcService(new WireMock(wireMockPort), "ai.pipestream.platform.registration.PlatformRegistration");
    }

    public PlatformRegistrationMock(WireMockServer wireMock) {
        this.mockService = new WireMockGrpcService(new WireMock(wireMock.port()), "ai.pipestream.platform.registration.PlatformRegistration");
    }

    public PlatformRegistrationMock mockServiceRegistration() {
        this.mockService.stubFor(WireMockGrpcCompat.method("RegisterService").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)RegistrationEvent.newBuilder().setEventType(EventType.STARTED).setMessage("Service registration started - streaming simulation").build())));
        return this;
    }

    public PlatformRegistrationMock mockServiceRegistrationCompleted() {
        this.mockService.stubFor(WireMockGrpcCompat.method("RegisterService").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)RegistrationEvent.newBuilder().setEventType(EventType.COMPLETED).setMessage("Service registration completed successfully").build())));
        return this;
    }

    public PlatformRegistrationMock mockModuleRegistration() {
        this.mockService.stubFor(WireMockGrpcCompat.method("RegisterModule").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)RegistrationEvent.newBuilder().setEventType(EventType.STARTED).setMessage("Module registration started - streaming simulation").build())));
        return this;
    }

    public PlatformRegistrationMock mockModuleRegistrationCompleted() {
        this.mockService.stubFor(WireMockGrpcCompat.method("RegisterModule").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)RegistrationEvent.newBuilder().setEventType(EventType.COMPLETED).setMessage("Module registration completed successfully").build())));
        return this;
    }

    public PlatformRegistrationMock mockListServices() {
        this.mockService.stubFor(WireMockGrpcCompat.method("ListServices").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)ServiceListResponse.newBuilder().addServices(ServiceDetails.newBuilder().setServiceName("repository-service").setServiceId("repo-1").setHost("localhost").setPort(8080).setVersion("1.0.0").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).addServices(ServiceDetails.newBuilder().setServiceName("account-manager").setServiceId("account-1").setHost("localhost").setPort(38105).setVersion("1.0.0").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).setAsOf(Timestamp.getDefaultInstance()).setTotalCount(2).build())));
        return this;
    }

    public PlatformRegistrationMock mockListModules() {
        this.mockService.stubFor(WireMockGrpcCompat.method("ListModules").willReturn(WireMockGrpcCompat.message((MessageOrBuilder)ModuleListResponse.newBuilder().addModules(ModuleDetails.newBuilder().setModuleName("parser").setServiceId("parser-1").setHost("localhost").setPort(8081).setVersion("1.0.0").setInputFormat("text/plain").setOutputFormat("application/json").addDocumentTypes("text").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).addModules(ModuleDetails.newBuilder().setModuleName("chunker").setServiceId("chunker-1").setHost("localhost").setPort(8082).setVersion("1.0.0").setInputFormat("application/json").setOutputFormat("application/json").addDocumentTypes("text").setIsHealthy(true).setRegisteredAt(Timestamp.getDefaultInstance()).setLastHealthCheck(Timestamp.getDefaultInstance()).build()).setAsOf(Timestamp.getDefaultInstance()).setTotalCount(2).build())));
        return this;
    }

    public WireMockGrpcService getService() {
        return this.mockService;
    }
}

