/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.grpc.wiremock;

import ai.pipestream.grpc.wiremock.AccountManagerMock;
import ai.pipestream.grpc.wiremock.PlatformRegistrationMock;
import ai.pipestream.grpc.wiremock.SimpleServiceMock;
import com.github.tomakehurst.wiremock.WireMockServer;

public class ServiceMocks {
    private final WireMockServer wireMockServer;
    private PlatformRegistrationMock platformRegistrationMock;
    private AccountManagerMock accountManagerMock;
    private SimpleServiceMock repositoryServiceMock;
    private SimpleServiceMock mappingServiceMock;
    private SimpleServiceMock engineServiceMock;
    private SimpleServiceMock designModeServiceMock;

    public ServiceMocks(WireMockServer wireMockServer) {
        this.wireMockServer = wireMockServer;
    }

    public PlatformRegistrationMock platformRegistration() {
        if (this.platformRegistrationMock == null) {
            this.platformRegistrationMock = new PlatformRegistrationMock(this.wireMockServer);
        }
        return this.platformRegistrationMock;
    }

    public AccountManagerMock accountManager() {
        if (this.accountManagerMock == null) {
            this.accountManagerMock = new AccountManagerMock(this.wireMockServer.port());
        }
        return this.accountManagerMock;
    }

    public SimpleServiceMock repository() {
        if (this.repositoryServiceMock == null) {
            this.repositoryServiceMock = new SimpleServiceMock(this.wireMockServer.port());
        }
        return this.repositoryServiceMock;
    }

    public SimpleServiceMock mapping() {
        if (this.mappingServiceMock == null) {
            this.mappingServiceMock = new SimpleServiceMock(this.wireMockServer.port());
        }
        return this.mappingServiceMock;
    }

    public SimpleServiceMock engine() {
        if (this.engineServiceMock == null) {
            this.engineServiceMock = new SimpleServiceMock(this.wireMockServer.port());
        }
        return this.engineServiceMock;
    }

    public SimpleServiceMock designMode() {
        if (this.designModeServiceMock == null) {
            this.designModeServiceMock = new SimpleServiceMock(this.wireMockServer.port());
        }
        return this.designModeServiceMock;
    }

    public ServiceMocks setupDefaults() {
        this.platformRegistration().mockServiceRegistration().mockModuleRegistration();
        this.accountManager().mockCreateAccount("default-account", "Default Account", "Default test account").mockGetAccount("default-account", "Default Account", "Default test account", true);
        this.repository().setupDefaults();
        this.mapping().setupDefaults();
        this.engine().setupDefaults();
        this.designMode().setupDefaults();
        return this;
    }

    public ServiceMocks reset() {
        this.platformRegistrationMock = null;
        this.accountManagerMock = null;
        this.repositoryServiceMock = null;
        this.mappingServiceMock = null;
        this.engineServiceMock = null;
        this.designModeServiceMock = null;
        return this;
    }
}

